/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.selenium.junit.annotations.UserTimeZone;
import com.adobe.cq.testing.selenium.junit.extensions.BrowserProxyExtension;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Config;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdriverSetupExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
LogEventListener {
    private static final String LISTENER_NAME = "uitest";
    public static final String EVENT_LOGGER_MESSAGE_FMT = "subject={} element={} duration={} status={} error={}";
    private Logger logger = null;
    private static final ThreadLocal<WebDriverManager> localWdm = new ThreadLocal();
    public static final String BUILD_REPORTS_SCREENSHOTS = "build/reports/tests/screenshots";
    public static final String BUILD_REPORTS_RECORDINGS = "build/reports/tests/recordings";

    public void beforeAll(ExtensionContext extensionContext) {
        try {
            Files.createDirectories(Path.of(BUILD_REPORTS_SCREENSHOTS, new String[0]), new FileAttribute[0]);
            if (this.isRecordingEnabled()) {
                Files.createDirectories(Path.of(BUILD_REPORTS_RECORDINGS, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(WebdriverSetupExtension.class).error("Could not create reports folder", (Throwable)ex);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.logger = LoggerFactory.getLogger((Class)((Class)extensionContext.getTestClass().orElseThrow(IllegalStateException::new)));
        this.logger.info("This extension instance {}", (Object)this);
        WebDriverManager wdm = this.setupWebdriver(extensionContext);
        WebDriver driver = wdm.create();
        wdm.getWebDriverList().forEach(wd -> this.logger.info("Docker webdriver {}", wd));
        WebDriverRunner.setWebDriver((WebDriver)driver);
        driver.manage().window().maximize();
        String listenerName = this.getListenerName();
        if (!SelenideLogger.hasListener((String)listenerName)) {
            SelenideLogger.addListener((String)listenerName, (LogEventListener)this);
        }
        localWdm.set(wdm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext extensionContext) {
        WebDriverManager wdm = localWdm.get();
        if (!Objects.isNull(wdm)) {
            try {
                this.dumpBrowserLogs();
                SelenideLogger.removeListener((String)LISTENER_NAME);
                boolean failed = extensionContext.getExecutionException().isPresent();
                this.saveScreenshotOnFail(((Method)extensionContext.getTestMethod().orElseThrow()).getName(), failed);
                this.quitHandleRecordings(wdm, !failed);
            }
            finally {
                wdm.quit();
            }
        }
        localWdm.remove();
    }

    private void saveScreenshotOnFail(String prefix, boolean failed) {
        try {
            if (failed) {
                String screenshotFileName = String.format("%s_%d", prefix, System.currentTimeMillis());
                Screenshot screenshot = ScreenShotLaboratory.getInstance().takeScreenshot(WebDriverRunner.driver(), screenshotFileName, true, true);
                this.logger.error("Test Failed: image at {}, html at {}", (Object)screenshot.getImage(), (Object)screenshot.getSource());
            }
        }
        catch (Exception err) {
            this.logger.error("Cannot save screenshot due to error", (Throwable)err);
        }
    }

    private void quitHandleRecordings(WebDriverManager manager, boolean removeRecordings) {
        ArrayList<Path> recordingList = new ArrayList<Path>();
        if (this.isRecordingEnabled() && this.isRunningInDocker() && this.keepRecordingOnFailureOnly() && removeRecordings) {
            recordingList.add(manager.getDockerRecordingPath(WebDriverRunner.getWebDriver()));
        }
        manager.quit();
        recordingList.forEach(path -> {
            try {
                this.logger.debug("Deleting on exit {} (since test does not fail)", path);
                path.toFile().deleteOnExit();
            }
            catch (Exception e) {
                this.logger.warn("Exception trying to delete recording {}", path);
            }
        });
    }

    private boolean isRunningInDocker() {
        WebDriverManager wdm = localWdm.get();
        return null != wdm && null != wdm.getDockerBrowserContainerId();
    }

    public void afterEvent(LogEvent logEvent) {
        this.logger.info(EVENT_LOGGER_MESSAGE_FMT, new Object[]{logEvent.getSubject(), logEvent.getElement(), logEvent.getDuration(), logEvent.getStatus(), logEvent.getError()});
    }

    public void beforeEvent(LogEvent logEvent) {
        this.logger.info("subject={} element={}", (Object)logEvent.getSubject(), (Object)logEvent.getElement());
    }

    private String getListenerName() {
        return String.format("%s-%d", LISTENER_NAME, Thread.currentThread().getId());
    }

    private String getUserTimeZone(ExtensionContext ec) {
        UserTimeZone annotation = ((Method)ec.getTestMethod().orElseThrow(IllegalStateException::new)).getAnnotation(UserTimeZone.class);
        if (Objects.isNull(annotation) && Objects.isNull(annotation = ((Class)ec.getTestClass().orElseThrow(IllegalAccessError::new)).getAnnotation(UserTimeZone.class))) {
            return "none";
        }
        return annotation.tz();
    }

    private WebDriverManager setupWebdriver(ExtensionContext ec) {
        String userTimeZone = this.getUserTimeZone(ec);
        WebDriverManager wdm = WebDriverManager.getInstance();
        if (BrowserProxyExtension.isEnabled()) {
            ChromeOptions chromeOptions = new ChromeOptions();
            wdm.capabilities((Capabilities)chromeOptions);
            chromeOptions.addArguments(new String[]{"--ignore-certificate-errors", "--user-data-dir=/tmp/insecurechrome"});
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
            desiredCapabilities.setCapability("proxy", (Object)BrowserProxyExtension.getSeleniumProxy());
            chromeOptions.merge((Capabilities)desiredCapabilities);
        }
        if (!StringUtils.equals((String)"none", (String)userTimeZone)) {
            this.logger.info("Setting docker timezone with {}", (Object)userTimeZone);
            wdm.config().setDockerTimezone(userTimeZone);
        }
        wdm.config().setDockerScreenResolution("1920x1080x24");
        wdm.config().setDockerStopTimeoutSec(30);
        if (this.isRecordingEnabled()) {
            wdm.enableRecording();
            wdm.config().setDockerRecordingFrameRate(4);
            wdm.config().setDockerRecordingOutput(Paths.get(BUILD_REPORTS_RECORDINGS, new String[0]));
            wdm.config().setDockerRecordingPrefix(String.format("%s_", ((Method)ec.getTestMethod().orElseThrow()).getName()));
        }
        return wdm;
    }

    private boolean isRecordingEnabled() {
        boolean useCustomImage = StringUtils.isNotBlank((String)new Config().getDockerCustomImage());
        return !useCustomImage && Boolean.parseBoolean(System.getProperty("sel.jup.recording", "false"));
    }

    private boolean keepRecordingOnFailureOnly() {
        return Boolean.parseBoolean(System.getProperty("sel.jup.recording.when.failure", "true"));
    }

    private void dumpBrowserLogs() {
        try {
            List logs = Selenide.getWebDriverLogs((String)"browser");
            this.logger.error("================== BROWSER LOGS =======================");
            logs.forEach(entry -> this.logger.error(entry));
            this.logger.error("=======================================================");
        }
        catch (UnsupportedCommandException ex) {
            this.logger.error("dumpBrowserLogs not possible on this browser");
        }
    }

    public static WebDriverManager getWebdriverManager() {
        return localWdm.get();
    }

    static {
        Configuration.timeout = 30000L;
        Configuration.reportsFolder = BUILD_REPORTS_SCREENSHOTS;
        String browserType = System.getProperty("sel.jup.default.browser", "chrome-in-docker");
        System.setProperty("wdm.defaultBrowser", browserType);
    }
}

