/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import java.util.concurrent.TimeoutException;

public final class CoralSelect
extends AEMBaseComponent {
    private static final String SELECTOR_ITEM_ELEMENT = "coral-select-item";
    private static final String SELECTOR_BUTTON = "button";

    public CoralSelect(String attribute) {
        super(String.format("coral-select[%s]", attribute));
    }

    public CoralSelect(SelenideElement parent) {
        super(parent);
    }

    public ElementsCollection items() {
        return this.element().$$(SELECTOR_ITEM_ELEMENT);
    }

    public SelenideElement getItemByValue(String value) {
        return this.element().$(String.format("%s[value=\"%s\"]", SELECTOR_ITEM_ELEMENT, value));
    }

    private void beforeSelect() {
        SelenideElement activeButton = this.element().find(SELECTOR_BUTTON);
        CoralPopOver popOver = this.popover();
        try {
            ElementUtils.clickUntil(activeButton, popOver.element(), Condition.visible, 10L, 500L);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Cannot open the CoralSelect, something when wrong with clickUntil");
        }
    }

    public void selectItemByIndex(int index) {
        CoralSelectList list = this.openSelectList();
        list.selectByIndex(index);
    }

    public void selectItemByLabel(String label) {
        CoralSelectList list = this.openSelectList();
        list.selectByLabel(label);
    }

    public void selectItemByValue(String value) {
        CoralSelectList list = this.openSelectList();
        list.selectByValue(value);
    }

    public SelenideElement selectedItem() {
        return this.element().$(String.format("%s[selected]", SELECTOR_ITEM_ELEMENT));
    }

    public String selectedItemLabel() {
        return this.selectedItem().getText();
    }

    public boolean hasItemBySelector(String selector) {
        return this.element().$(String.format("%s%s", SELECTOR_ITEM_ELEMENT, selector)).exists();
    }

    public CoralPopOver popover() {
        return new CoralPopOver("coral-popover.is-open[focusonshow=\"coral-selectlist\"]");
    }

    public CoralSelectList selectList() {
        CoralPopOver popOver = this.popover();
        popOver.waitVisible();
        return new CoralSelectList(popOver.element());
    }

    public CoralSelectList openSelectList() {
        this.beforeSelect();
        return this.selectList();
    }
}

