/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public class InsertComponentDialog
extends Dialog {
    private static final String CSS_SELECTOR = "coral-dialog.InsertComponentDialog";
    private static final String LIST_SELECTOR = ".InsertComponentDialog-list";
    private static final String SELECT_LIST_SELECTOR = "coral-selectlist.InsertComponentDialog-list";
    private static final String SEARCH_FIELD = "input[type='search']";
    private static final String CLOSE_BUTTON = "button[handle='closeButton']";
    private static final String SELECTOR_ITEM_ELEMENT = "coral-list-item";
    private CoralSelectList componentSelectList = new CoralSelectList("coral-selectlist.InsertComponentDialog-list");
    private CoralList componentList = new CoralList(".InsertComponentDialog-list");

    public InsertComponentDialog() {
        super(CSS_SELECTOR);
    }

    public SelenideElement getItemByValue(String value) {
        if (this.componentSelectList.isExisting()) {
            return this.componentSelectList.getItemByValue(value);
        }
        return this.element().$(String.format("%s[value=\"%s\"]", SELECTOR_ITEM_ELEMENT, value));
    }

    public void selectComponent(String resourceType) {
        if (this.componentSelectList.isExisting()) {
            ElementUtils.clickableClick(this.componentSelectList.getItemByValue(resourceType));
        } else {
            ElementUtils.clickableClick(this.getItemByValue(resourceType));
        }
        this.element().shouldNotBe(new Condition[]{Condition.visible});
    }

    public ElementsCollection getComponentList() {
        if (this.componentSelectList.isExisting()) {
            return this.componentSelectList.items();
        }
        return this.componentList.itemsCollection();
    }

    public void close() {
        ElementUtils.clickableClick(this.element().find(CLOSE_BUTTON));
        this.element().shouldNotBe(new Condition[]{Condition.visible});
    }

    public ElementsCollection search(String searchText) {
        int initialSize = this.getComponentList().size();
        this.element().find(SEARCH_FIELD).setValue(searchText);
        Helpers.waitForListSizeChange(initialSize, this.getComponentList(), 1000);
        return this.getComponentList();
    }
}

