/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public final class Breadcrumbs
extends AEMBaseComponent {
    private final String buttonSelector = String.format("%s  button.betty-breadcrumbs-button", this.getCssSelector());
    private final String popoverSelector = String.format("%s > coral-popover.betty-breadcrumbs-popover", this.getCssSelector());

    public Breadcrumbs() {
        super("betty-breadcrumbs");
    }

    private String createBreadcrumbsItemSelector(int index) {
        return this.popoverSelector + String.format(" coral-selectlist coral-selectlist-item:nth-child(%d)", index + 1);
    }

    public SelenideElement button() {
        return Selenide.$((String)this.buttonSelector).shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public SelenideElement popover() {
        Helpers.waitForElementAnimationFinished(this.popoverSelector);
        return Selenide.$((String)this.popoverSelector);
    }

    public SelenideElement openPopover() {
        this.button().click();
        return this.popover();
    }

    public SelenideElement getPopoverItemAt(int index) {
        String itemSelector = this.createBreadcrumbsItemSelector(index);
        return Selenide.$((String)itemSelector).shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
    }
}

