/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.I18N;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.By;

public final class Omnisearch
extends AEMBaseComponent {
    private static final String BUTTON_GRANITE_OMNISEARCH_TYPEAHEAD_CLOSE = "button.granite-omnisearch-typeahead-close";
    private static final String DIV_GRANITE_OMNISEARCH_TYPEAHEAD = "div.granite-omnisearch-typeahead";
    private final String actionBarItemPrefix;

    public Omnisearch() {
        super("granite-omnisearch-overlay");
        this.actionBarItemPrefix = ".granite-omnisearch-overlay coral-actionbar coral-actionbar-item ";
    }

    public SelenideElement searchField() {
        return Selenide.$((String)"input.granite-omnisearch-typeahead-input").should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public SelenideElement resultContent() {
        return Selenide.$((String)"#granite-omnisearch-result").should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public ElementsCollection resultMultiRows() {
        ElementsCollection collection = Selenide.$$((String)"#granite-omnisearch-result .granite-omnisearch-multiresult-row");
        collection.forEach(item -> item.should(Constants.EXISTS_ENABLED_VISIBLE));
        return collection;
    }

    public ElementsCollection allSimpleSearchResults() {
        Selenide.$((String)"#granite-omnisearch-result").should(Constants.EXISTS_ENABLED_VISIBLE);
        return Selenide.$$((String)"coral-masonry[id='granite-omnisearch-result'] > coral-masonry-item");
    }

    public void open() {
        if (Helpers.isUnifiedShellFrame()) {
            Selenide.switchTo().defaultContent();
            ElementUtils.clickableClick(Selenide.$((String)".spectrum-Tool.spectrum-Tool--quiet"));
            Helpers.switchToAemContentFrame();
        } else {
            ElementUtils.clickableClick(Selenide.$((String)"#granite-omnisearch-trigger"));
        }
        Selenide.$((String)BUTTON_GRANITE_OMNISEARCH_TYPEAHEAD_CLOSE).should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public void openViaSearchUrl() {
        Selenide.open((String)"/aem/search.html");
        Helpers.waitForElementAnimationFinished(DIV_GRANITE_OMNISEARCH_TYPEAHEAD);
    }

    public void close() {
        Helpers.waitForElementAnimationFinished(DIV_GRANITE_OMNISEARCH_TYPEAHEAD);
        Helpers.waitForElementAnimationFinished(BUTTON_GRANITE_OMNISEARCH_TYPEAHEAD_CLOSE);
        Selenide.$((String)BUTTON_GRANITE_OMNISEARCH_TYPEAHEAD_CLOSE).should(new Condition[]{Condition.visible}).click();
        Selenide.$((String)BUTTON_GRANITE_OMNISEARCH_TYPEAHEAD_CLOSE).shouldNot(new Condition[]{Condition.visible});
    }

    @Override
    public boolean isVisible() {
        return Helpers.isElementTopMost(DIV_GRANITE_OMNISEARCH_TYPEAHEAD);
    }

    public void toggleFilter() throws TimeoutException {
        String selector = "#granite-omnisearch-result-rail-toggle-button";
        String railPanelSelector = "coral-overlay div[id='granite-omnisearch-result-rail']";
        if (Selenide.$((String)"coral-overlay div[id='granite-omnisearch-result-rail']").is(Condition.visible)) {
            Selenide.$((String)"#granite-omnisearch-result-rail-toggle-button").should(Constants.EXISTS_ENABLED_VISIBLE).click();
        } else {
            ElementUtils.clickUntil(Selenide.$((String)"#granite-omnisearch-result-rail-toggle-button"), Selenide.$((String)"coral-overlay div[id='granite-omnisearch-result-rail']"), Condition.visible, 5L, 1000L);
        }
        Helpers.waitForElementAnimationFinished(Selenide.$((String)"coral-overlay div[id='granite-omnisearch-result-rail']"));
    }

    public void search(String searchText) {
        this.searchField().setValue(searchText + "\ue007");
        Selenide.$((String)"#granite-omnisearch-result-content").should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public void openWorkflowSearchResult(int rowNumber, int itemNumber) {
        String selector = "#granite-omnisearch-result .granite-omnisearch-multiresult-row:nth-child(" + rowNumber + ")";
        SelenideElement row = Selenide.$((String)selector).should(Constants.EXISTS_ENABLED_VISIBLE);
        row.$("coral-masonry coral-masonry-item:nth-child(" + itemNumber + ")").should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public void openSimpleSearchResult(int itemNumber) {
        String selector = "coral-masonry[id='granite-omnisearch-result'] > coral-masonry-item:nth-child(" + itemNumber + ")";
        Selenide.$((String)selector).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public void openFirstAssetFromResults() {
        String selector = "#granite-omnisearch-result coral-card[data-item-type=\"asset\"]";
        Selenide.$$((String)"#granite-omnisearch-result coral-card[data-item-type=\"asset\"]").shouldHave(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)0)}).get(0).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public SelenideElement getFirstLaunchFromResults() {
        String selector = "#granite-omnisearch-result .card-cq-launches";
        return Selenide.$$((String)"#granite-omnisearch-result .card-cq-launches").shouldHave(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)0)}).get(0);
    }

    public void showSuggestions(String searchText) {
        this.searchField().setValue(searchText);
        Selenide.$((String)"coral-overlay[target='.granite-omnisearch-typeahead']").should(Constants.EXISTS_ENABLED_VISIBLE);
        Selenide.sleep((long)3000L);
    }

    public void selectPredicate(String predicateValue) {
        SelenideElement predicate = Selenide.$((String)("button[data-granite-omnisearch-typeahead-suggestion-value='" + predicateValue + "']"));
        predicate.should(Constants.EXISTS_ENABLED_VISIBLE).click();
        Selenide.$((String)"coral-overlay.granite-omnisearch-typeahead-overlay").shouldNot(new Condition[]{Condition.visible});
    }

    ElementsCollection getAllTagsFromTagList() {
        return Selenide.$$((String)".granite-omnisearch-typeahead-tags coral-tag");
    }

    public void openFromFilter() {
        String i18nFilter = I18N.geti18nString("Filter");
        SelenideElement railToggle = Selenide.$((String)"#shell-collectionpage-rail-toggle");
        railToggle.should(Constants.EXISTS_ENABLED_VISIBLE).click();
        String query = String.format("//coral-selectlist-item[contains(text(), '%s')]", i18nFilter);
        railToggle.find(By.xpath((String)query)).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public SelenideElement getActionBarItem(String selector) {
        return Selenide.$((String)(this.actionBarItemPrefix + selector));
    }

    public SelenideElement getPredicateInput(String name) {
        String selector = String.format(".path-predicate foundation-autocomplete[name=\"%s\"] input[is=\"coral-textfield\"]", name);
        return Selenide.$((String)selector).should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public SelenideElement getPredicateTag(String name) {
        return Selenide.$((String)("coral-taglist coral-tag[name='" + name + "']")).should(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public int getSearchResultCount() {
        return Integer.parseInt(Selenide.$((String)"granite-pagingstatus.granite-collection-pagingstatus").should(Constants.EXISTS_ENABLED_VISIBLE).getAttribute("guesstotal"));
    }
}

