/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.cq.sites;

import com.adobe.cq.testing.selenium.pageobject.granite.BasePage;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralMultiField;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.pagewidgets.cq.sites.PageSelector;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.adobe.cq.testing.selenium.utils.ExpectNav;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.util.Arrays;
import java.util.Optional;

public final class PropertiesPage
extends BasePage {
    private static final String SITE_PROPERTIES_URL = "/mnt/overlay/wcm/core/content/sites/properties.html?";
    private static final String TRACKING_ELEMENT = "\"element\":\"%s\"";
    private final SelenideElement cancelButton = Selenide.$((String)"#shell-propertiespage-closeactivator");
    private final SelenideElement saveCloseButton = Selenide.$((String)"#shell-propertiespage-doneactivator");
    private final SelenideElement saveButton = Selenide.$((String)"#shell-propertiespage-saveactivator");
    private final SelenideElement dropDownButton = Selenide.$((String)"coral-actionbar-secondary button[icon=\"chevronDown\"]");
    private final ElementsCollection coralTabs = Selenide.$$((String)"coral-tab");
    private final SelenideElement bulkForm = Selenide.$((String)".cq-siteadmin-admin-properties-bulk");

    public PropertiesPage(String ... pagePath) {
        super(SITE_PROPERTIES_URL + PropertiesPage.getItemParams(pagePath));
    }

    public PropertiesPage openBulk(String ... pagePath) {
        return (PropertiesPage)super.open(SITE_PROPERTIES_URL + PropertiesPage.getItemParams(pagePath));
    }

    @Override
    public void waitReady() {
        super.waitReady();
        this.cancelButton.should(new Condition[]{Condition.visible});
        this.saveCloseButton.should(new Condition[]{Condition.visible});
    }

    private static String getItemParams(String ... pagePath) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(pagePath).forEach(p -> {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append("item=").append((String)p);
        });
        return sb.toString();
    }

    public <T> T clickTab(String tabName, Class<T> clazz) {
        T target;
        Optional<SelenideElement> tabElement = this.coralTabs.stream().filter(selenideElement -> selenideElement.getAttribute("data-foundation-tracking-event").contains(this.getTrackingElementName(tabName))).findFirst();
        if (tabElement.isEmpty()) {
            throw new AssertionError((Object)("Couldn't find " + tabName));
        }
        SelenideElement tElement = tabElement.get();
        tElement.shouldHave(new Condition[]{Condition.attribute((String)"aria-controls")});
        String panelId = tElement.getAttribute("aria-controls");
        ElementUtils.clickableClick(tElement);
        try {
            target = clazz.getDeclaredConstructor(String.class).newInstance(panelId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class type " + clazz.getName() + " doesn't have default constructor");
        }
        return target;
    }

    public PropertiesPage save() {
        ElementUtils.clickableClick(this.dropDownButton);
        CoralPopOver popOver = CoralPopOver.firstOpened();
        popOver.isVisible();
        ElementUtils.clickableClick(this.saveButton);
        return this;
    }

    public PropertiesPage cancel() {
        ElementUtils.clickableClick(this.cancelButton);
        return this;
    }

    public void saveAndClose() {
        ExpectNav.on(() -> ElementUtils.clickableClick(this.saveCloseButton));
    }

    public SelenideElement getBulkForm() {
        return this.bulkForm;
    }

    public SelenideElement getSaveButton() {
        return this.saveButton;
    }

    public SelenideElement getSaveCloseButton() {
        return this.saveCloseButton;
    }

    public ElementsCollection getCoralTabs() {
        return this.coralTabs;
    }

    private String getTrackingElementName(String thumbnail) {
        return String.format(TRACKING_ELEMENT, thumbnail);
    }

    public Tabs tabs() {
        return new Tabs();
    }

    public PageSelector getPageSelector() {
        return new PageSelector();
    }

    public PropertiesPage expectConfirmation() {
        this.waitForMessage("The form has been submitted successfully");
        return this;
    }

    public class Tabs {
        public Basic basic() {
            return new Basic();
        }

        public LiveCopy liveCopy() {
            return new LiveCopy();
        }

        public CloudServices cloudServices() {
            return new CloudServices();
        }

        public class LiveCopy {
            public CoralCheckbox liveCopyInheritance() {
                return new CoralCheckbox("coral-checkbox.cq-siteadmin-admin-properties-livecopy-isdeep");
            }

            public CoralCheckbox inheritRolloutConfigs() {
                return new CoralCheckbox("coral-checkbox.cq-siteadmin-admin-properties-livecopy-inheritrolloutconfigs");
            }
        }

        public class CloudServices {
            public CoralCheckbox cloudInheritance() {
                return new CoralCheckbox("coral-checkbox.cq-CloudServices-inheritance");
            }
        }

        public class Basic {
            public SelenideElement title() {
                return FormField.TITLE.getFullyDecoratedElement("input", new String[0]);
            }

            public SelenideElement pageTitle() {
                return FormField.PAGE_TITLE.getFullyDecoratedElement("input", new String[0]);
            }

            public SelenideElement subtitle() {
                return FormField.SUBTITLE.getFullyDecoratedElement("input", new String[0]);
            }

            public SelenideElement navTitle() {
                return FormField.NAV_TITLE.getFullyDecoratedElement("input", new String[0]);
            }

            public SelenideElement toggleTitleInheritance() {
                return new AEMBaseComponent("a.cq-msm-property-toggle-inheritance[data-toggle-property-inheritance='jcr:title'] coral-icon").element();
            }

            public SelenideElement description() {
                return FormField.DESCRIPTION.getFullyDecoratedElement("textarea", new String[0]);
            }

            public CoralCheckbox hideInNav() {
                return new CoralCheckbox("coral-checkbox" + FormField.HIDE_IN_NAV);
            }

            public CoralCheckbox slingRedirect() {
                return new CoralCheckbox("coral-checkbox" + FormField.SLING_REDIRECT);
            }

            public CoralMultiField vanityPath() {
                return new CoralMultiField("./sling:vanityPath");
            }

            public boolean isTagPresent(String tag) {
                ElementsCollection tagList = Selenide.$((String)"coral-taglist[name='./cq:tags']").$$("coral-tag");
                boolean present = false;
                for (int i = 0; i < tagList.size(); ++i) {
                    if (!tagList.get(i).getText().trim().equals(tag)) continue;
                    present = true;
                    break;
                }
                return present;
            }
        }
    }
}

