/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.util.stream.Stream;
import org.openqa.selenium.WebElement;

public class CoralMultiField
extends AEMBaseComponent {
    private static final String SELECTOR_PATTERN = "coral-multifield[data-granite-coral-multifield-name=\"%s\"]";
    private static final int SMALL_DELAY = 250;
    private SelenideElement addButton = this.element().$("button[coral-multifield-add]");

    public CoralMultiField(String name) {
        super(String.format(SELECTOR_PATTERN, name));
    }

    public CoralMultiField(SelenideElement parent) {
        super(parent);
    }

    public MultiFieldItem add() {
        ElementUtils.clickableClick(this.addButton);
        Selenide.sleep((long)250L);
        return this.items().reduce((first, second) -> second).orElse(null);
    }

    public Stream<MultiFieldItem> items() {
        ElementsCollection items = this.element().$$("coral-multifield-item");
        return items.stream().map(i -> new MultiFieldItem((SelenideElement)i));
    }

    public final class MultiFieldItem
    extends AEMBaseComponent {
        private MultiFieldItem(SelenideElement itemElement) {
            super(itemElement);
        }

        public void remove() {
            ElementUtils.clickableClick(this.element().$("button[handle=\"remove\"]"));
        }

        public void move(MultiFieldItem item) {
            SelenideElement moveButton = this.element().$("button[handle=\"move\"]");
            Selenide.actions().dragAndDrop((WebElement)moveButton, (WebElement)item.element()).perform();
        }

        public SelenideElement input() {
            return this.element().$("coral-multifield-item-content input");
        }
    }
}

