/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class RichTextToolbar
extends AEMBaseComponent {
    private static final String CSS_SELECTOR = ".rte-toolbar";

    public RichTextToolbar() {
        super(Selenide.$$((String)CSS_SELECTOR).filterBy(Condition.visible).first());
    }

    public RichTextToolbar clickSaveButton() {
        return this.clickButton(Action.SAVE);
    }

    public RichTextToolbar clickCloseButton() {
        return this.clickButton(Action.CLOSE);
    }

    public RichTextToolbar clickFormatButton() {
        return this.clickButton(Action.FORMAT);
    }

    public RichTextToolbar clickJustifyButton() {
        return this.clickButton(Action.JUSTIFY);
    }

    public RichTextToolbar clickListButton() {
        return this.clickButton(Action.LISTS);
    }

    public RichTextToolbar clickLinkButton() {
        return this.clickButton(Action.LINK);
    }

    public RichTextToolbar clickUnlinkButton() {
        return this.clickButton(Action.UNLINK);
    }

    public RichTextToolbar clickBoldButton() {
        return this.clickButton(Action.FORMAT_BOLD);
    }

    public RichTextToolbar clickItalicButton() {
        return this.clickButton(Action.FORMAT_ITALIC);
    }

    public RichTextToolbar clickUnderlineButton() {
        return this.clickButton(Action.FORMAT_UNDERLINE);
    }

    public RichTextToolbar clickJustifyLeftButton() {
        return this.clickButton(Action.JUSTIFY_LEFT);
    }

    public RichTextToolbar clickJustifyCenterButton() {
        return this.clickButton(Action.JUSTIFY_CENTER);
    }

    public RichTextToolbar clickJustifyRightButton() {
        return this.clickButton(Action.JUSTIFY_RIGHT);
    }

    public RichTextToolbar clickJustifyJustifyButton() {
        return this.clickButton(Action.JUSTIFY_JUSTIFY);
    }

    public RichTextToolbar clickListsUnorderedButton() {
        return this.clickButton(Action.LISTS_UNORDERED);
    }

    public RichTextToolbar clickListsOrderedButton() {
        return this.clickButton(Action.LISTS_ORDERED);
    }

    public RichTextToolbar clickListsOutdentButton() {
        return this.clickButton(Action.LISTS_OUTDENT);
    }

    public RichTextToolbar clickListsIndentdButton() {
        return this.clickButton(Action.LISTS_INDENT);
    }

    public RichTextToolbar clickButton(Action action) {
        SelenideElement button = this.element().find(action.getSelector());
        button.shouldBe(new Condition[]{Condition.visible});
        ElementUtils.clickableClick(button);
        return this;
    }

    public SelenideElement getButton(Action action) {
        SelenideElement button = this.element().find(action.getSelector());
        button.should(new Condition[]{Condition.exist});
        return button;
    }

    public static enum Action {
        SAVE("control#save"),
        CLOSE("control#close"),
        FORMAT("#format"),
        JUSTIFY("#justify"),
        LISTS("#lists"),
        LINK("links#modifylink"),
        ANCHOR("links#anchor"),
        UNLINK("links#unlink"),
        FIND("findreplace#find"),
        REPLACE("findreplace#replace"),
        UNDO("undo#undo"),
        REDO("undo#redo"),
        TABLE("table#createoredit"),
        IMAGE("image#imageProps"),
        SPELLCHECK("spellcheck#checktext"),
        EDIT_CUT("edit#cut"),
        EDIT_COPY("edit#copy"),
        EDIT_PASTE("edit#paste-default"),
        EDIT_PASTE_PLAINTEXT("edit#paste-plaintext"),
        EDIT_PASTE_WORDHTML("edit#paste-wordhtml"),
        FORMAT_BOLD("format#bold"),
        FORMAT_ITALIC("format#italic"),
        FORMAT_UNDERLINE("format#underline"),
        FORMAT_SUBSCRIPT("subsuperscript#subscript"),
        FORMAT_SUPERSCRIPT("subsuperscript#superscript"),
        JUSTIFY_LEFT("justify#justifyleft"),
        JUSTIFY_CENTER("justify#justifycenter"),
        JUSTIFY_RIGHT("justify#justifyright"),
        JUSTIFY_JUSTIFY("justify#justifyjustify"),
        LISTS_UNORDERED("lists#unordered"),
        LISTS_ORDERED("lists#ordered"),
        LISTS_OUTDENT("lists#outdent"),
        LISTS_INDENT("lists#indent");

        private final String action;

        private Action(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        public String getSelector() {
            return "[data-action='" + this.action + "']";
        }
    }
}

