/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq.tabs;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.AutoCompleteField;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public final class PermissionsTab
extends AEMBaseComponent {
    private static final SelenideElement ADD_PERMISSION = Selenide.$((String)"button.js-cq-sites-AddPermissionsDialog-show");
    private static final SelenideElement EDIT_CUG = Selenide.$((String)"button.js-cq-sites-ClosedUserGroupDialog-show");
    private static final SelenideElement EFFECTIVE_PERMISSIONS = Selenide.$((String)"button.js-cq-sites-EffectivePermissionsDialog-show ");
    private static final ElementsCollection CUG_ITEMS = Selenide.$$((String)"table.js-cq-sites-ClosedUserGroup-permissions tr.js-cq-sites-PermissionsProperties-row");
    private static final ElementsCollection PERMISSIONS_ITEMS = Selenide.$$((String)"table.js-cq-sites-UserGroup-permissions tr.js-cq-sites-PermissionsProperties-row");
    private static final String EDIT_PERMISSION = "button.js-cq-sites-PermissionsProperties-edit";
    private static final String DELEETE_PERMISSION = "button.js-cq-sites-PermissionsProperties-delete";

    public PermissionsTab(String panelId) {
        super("#" + panelId);
    }

    public SelenideElement getAddPermission() {
        return ADD_PERMISSION;
    }

    public SelenideElement getEditCUG() {
        return EDIT_CUG;
    }

    public AddPermissionsDialog addPermission() {
        ElementUtils.clickableClick(ADD_PERMISSION);
        return new AddPermissionsDialog();
    }

    public EditCUGDialog editCUG() {
        ElementUtils.clickableClick(EDIT_CUG);
        return new EditCUGDialog();
    }

    public ElementsCollection cugList() {
        return CUG_ITEMS;
    }

    public ElementsCollection permissionsList() {
        return PERMISSIONS_ITEMS;
    }

    public boolean isReadPermissionGranted(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        if (!userRow.isDisplayed()) {
            return false;
        }
        return userRow.$$("td").get(1).$("[icon='check']").isDisplayed();
    }

    public boolean isModifyPermissionGranted(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        if (!userRow.isDisplayed()) {
            return false;
        }
        return userRow.$$("td").get(2).$("[icon='check']").isDisplayed();
    }

    public boolean isDeletePermissionGranted(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        if (!userRow.isDisplayed()) {
            return false;
        }
        return userRow.$$("td").get(3).$("[icon='check']").isDisplayed();
    }

    public boolean isReplicatePermissionGranted(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        if (!userRow.isDisplayed()) {
            return false;
        }
        return userRow.$$("td").get(4).$("[icon='check']").isDisplayed();
    }

    public boolean isCreatePermissionGranted(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        if (!userRow.isDisplayed()) {
            return false;
        }
        return userRow.$$("td").get(5).$("[icon='check']").isDisplayed();
    }

    public EditPermissionDialog editPermission(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        userRow.find(EDIT_PERMISSION).click();
        return new EditPermissionDialog();
    }

    public void deleteUserPermission(String userName) {
        SelenideElement userRow = PERMISSIONS_ITEMS.filter(Condition.matchText((String)userName)).first();
        userRow.find(DELEETE_PERMISSION).click();
        new Dialog().clickWarning();
    }

    public EffectivePermissionDialog openEffectivePermissions() {
        EFFECTIVE_PERMISSIONS.click();
        return new EffectivePermissionDialog();
    }

    public class EffectivePermissionDialog
    extends Dialog {
        public EffectivePermissionDialog() {
            super("coral-dialog.js-cq-sites-EffectivePermissionsDialog");
        }

        public void close() {
            Selenide.$((String)(this.getCssSelector() + " button[handle='closeButton']")).click();
        }
    }

    public class AddPermissionsDialog
    extends Dialog {
        private final AutoCompleteField autoCompleteField;
        private final CoralCheckbox cbRead;
        private final CoralCheckbox cbCreate;
        private final CoralCheckbox cbModify;
        private final CoralCheckbox cbDelete;
        private final CoralCheckbox cbReplicate;

        public AddPermissionsDialog() {
            super("coral-dialog.js-cq-sites-CreatePermissionsDialog");
            this.autoCompleteField = new AutoCompleteField("css:.js-cq-sites-CreatePermissionsDialog-authorizableList");
            this.cbRead = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"read\"]");
            this.cbCreate = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"create\"]");
            this.cbModify = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"modify\"]");
            this.cbDelete = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"delete\"]");
            this.cbReplicate = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"replicate\"]");
        }

        public AutoCompleteField authorizableList() {
            return this.autoCompleteField;
        }

        public CoralCheckbox read() {
            return this.cbRead;
        }

        public CoralCheckbox create() {
            return this.cbCreate;
        }

        public CoralCheckbox modify() {
            return this.cbModify;
        }

        public CoralCheckbox delete() {
            return this.cbDelete;
        }

        public CoralCheckbox replicate() {
            return this.cbReplicate;
        }
    }

    public class EditPermissionDialog
    extends Dialog {
        private final CoralCheckbox cbRead;
        private final CoralCheckbox cbCreate;
        private final CoralCheckbox cbModify;
        private final CoralCheckbox cbDelete;
        private final CoralCheckbox cbReplicate;

        public EditPermissionDialog() {
            super("coral-dialog.js-cq-sites-EditPermissionsDialog");
            this.cbRead = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"read\"]");
            this.cbCreate = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"create\"]");
            this.cbModify = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"modify\"]");
            this.cbDelete = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"delete\"]");
            this.cbReplicate = new CoralCheckbox(this.getCssSelector() + " coral-checkbox[name=\"replicate\"]");
        }

        public CoralCheckbox read() {
            return this.cbRead;
        }

        public CoralCheckbox create() {
            return this.cbCreate;
        }

        public CoralCheckbox modify() {
            return this.cbModify;
        }

        public CoralCheckbox delete() {
            return this.cbDelete;
        }

        public CoralCheckbox replicate() {
            return this.cbReplicate;
        }
    }

    public class EditCUGDialog
    extends Dialog {
        private final AutoCompleteField autoCompleteField;

        public EditCUGDialog() {
            super("coral-dialog.js-cq-sites-CUGPermissionsDialog");
            this.autoCompleteField = new AutoCompleteField("css:.js-cq-sites-CUGPermissionsDialog-authorizableList");
        }

        public AutoCompleteField cugFinder() {
            return this.autoCompleteField;
        }
    }
}

