/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.selenium.utils.Network;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.proxy.CaptureType;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.openqa.selenium.Proxy;

public class BrowserProxyExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public static final String BROWSER_PROXY_STORE_ID = "browser-proxy-in-store";
    private static BrowserMobProxyServer proxy;
    private static Proxy seleniumProxy;
    private static int proxyPort;

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        if (BrowserProxyExtension.isEnabled()) {
            Har har = proxy.getHar();
            har.writeTo(FileUtils.getFile((String[])new String[]{((Method)extensionContext.getTestMethod().get()).getName() + ".har"}));
            proxy.endHar();
        }
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        if (BrowserProxyExtension.isEnabled()) {
            proxy.newHar("Capture " + ((Method)extensionContext.getTestMethod().get()).getName());
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.isOfType(parameterContext, Proxy.class, BrowserMobProxyServer.class);
    }

    private boolean isOfType(ParameterContext context, Class ... clazz) {
        return Arrays.stream(clazz).anyMatch(p -> p.isAssignableFrom(context.getParameter().getType()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.isOfType(parameterContext, Proxy.class) ? seleniumProxy : proxy;
    }

    public static boolean isEnabled() {
        return proxyPort > 0;
    }

    public static Proxy getSeleniumProxy() {
        return seleniumProxy;
    }

    static {
        proxyPort = Integer.parseInt(System.getProperty("useProxyPort", "0"));
        if (proxyPort > 0) {
            proxy = new BrowserMobProxyServer();
            proxy.setTrustAllServers(true);
            proxy.enableHarCaptureTypes(new CaptureType[]{CaptureType.REQUEST_CONTENT, CaptureType.RESPONSE_CONTENT, CaptureType.REQUEST_COOKIES, CaptureType.RESPONSE_COOKIES});
            proxy.start(proxyPort);
            seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)proxy);
            String proxyURL = Network.proxyURL((BrowserMobProxy)proxy);
            seleniumProxy.setHttpProxy(proxyURL);
            seleniumProxy.setSslProxy(proxyURL);
        }
    }
}

