/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.cq.sites;

import com.adobe.cq.testing.selenium.pageobject.granite.ViewType;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.pagewidgets.cq.IncludeChildrenDialog;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Collection;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Picker;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Table;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Wizard;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;

public final class CreateWorkflowWizard
extends Wizard {
    private static final String CREATE_WF_WIZARD_URL = "/mnt/override/libs/wcm/core/content/common/startbulkworkflows.html";
    private static final SelenideElement CREATE_WF_FORM = Selenide.$((String)"form.cq-sites-startbulkworkflows-form");
    private static final SelenideElement SELECTION_MODEL_BUTTON = Selenide.$((String)"button[variant=\"_custom\"]");
    private static final SelenideElement WORKFLOW_TITLE = new FormField("workflowTitle").getFullyDecoratedElement("input", new String[0]);
    private static final SelenideElement PACKAGE_TITLE = new FormField("packageTitle").getFullyDecoratedElement("input", new String[0]);
    private static final CoralCheckbox KEEP_WORKFLOW_PACKAGE = new CoralCheckbox("coral-checkbox.cq-sites-startbulkworkflows-keeppackage");
    private static final Collection COLLECTION = new Table(".foundation-collection");

    public boolean isOpened() {
        return WebDriverRunner.url().contains(CREATE_WF_WIZARD_URL) && CREATE_WF_FORM.isDisplayed();
    }

    public void selectModel(String modelId) {
        ElementUtils.clickableClick(SELECTION_MODEL_BUTTON);
        CoralPopOver popOver = CoralPopOver.firstOpened();
        CoralSelectList list = new CoralSelectList(popOver.element());
        SelenideElement itemByValue = list.getItemByValue(modelId);
        itemByValue.scrollTo();
        ElementUtils.clickableClick(itemByValue);
    }

    public SelenideElement title() {
        return WORKFLOW_TITLE;
    }

    public SelenideElement packageTitle() {
        return PACKAGE_TITLE;
    }

    public CoralCheckbox keepWorkflowPackage() {
        return KEEP_WORKFLOW_PACKAGE;
    }

    public Collection collection() {
        return COLLECTION;
    }

    public CreateWorkflowActions actions() {
        return new CreateWorkflowActions();
    }

    public static final class CreateWorkflowActions {
        private static final SelenideElement ADD_CONTENT_BUTTON = Selenide.$((String)"[trackingelement=\"add content\"]");
        private static final SelenideElement INCLUDE_CHILDREN_BUTTON = Selenide.$((String)"[trackingelement=\"include children\"]");
        private static final SelenideElement REMOVE_SELECTION_BUTTON = Selenide.$((String)"[trackingelement=\"remove selection\"]");

        private CreateWorkflowActions() {
        }

        public SelenideElement getAddContent() {
            return ADD_CONTENT_BUTTON;
        }

        public SelenideElement getIncludeChildren() {
            return INCLUDE_CHILDREN_BUTTON;
        }

        public SelenideElement getRemoveSelection() {
            return REMOVE_SELECTION_BUTTON;
        }

        public Picker addContent() {
            ElementUtils.clickableClick(ADD_CONTENT_BUTTON);
            Picker pickerDialog = new Picker("coral-dialog.foundation-picker-collection", ViewType.COLUMN);
            pickerDialog.waitVisible();
            return pickerDialog;
        }

        public Dialog removeSelection() {
            ElementUtils.clickableClick(REMOVE_SELECTION_BUTTON);
            Dialog dialog = new Dialog("coral-dialog[role=\"alertdialog\"]");
            dialog.waitVisible();
            return dialog;
        }

        public IncludeChildrenDialog includeChildren() {
            ElementUtils.clickableClick(INCLUDE_CHILDREN_BUTTON);
            IncludeChildrenDialog dialog = new IncludeChildrenDialog();
            dialog.waitVisible();
            return dialog;
        }
    }
}

