/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.common;

import com.adobe.cq.testing.selenium.pagewidgets.common.BaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralReady;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AEMBaseComponent
extends BaseComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AEMBaseComponent.class);
    private static final String TRACKINGELEMENT_ATTRIBUTE = "trackingelement";
    private static final String TRACKING_EVENT_ATTRIBUTE = "data-foundation-tracking-event";
    private static final String COLLECTION_ACTION_ATTRIBUTE = "data-foundation-collection-action";
    private static final SelenideElement UI_MASK = Selenide.$((String)"div.foundation-ui-mask");

    public AEMBaseComponent(String selector) {
        super(selector);
    }

    public AEMBaseComponent(SelenideElement element) {
        super(element);
    }

    public void waitPageMasked() {
        UI_MASK.should(new Condition[]{Condition.exist});
    }

    public void waitPageUnmasked() {
        UI_MASK.shouldNot(new Condition[]{Condition.exist});
    }

    @Override
    public <T extends BaseComponent> T waitReady() {
        CoralReady.waitCoralReady(this.cssSelector);
        return (T)this;
    }

    public String getTrackingElement() {
        String trackingEvent;
        String trackingelement = this.element().getAttribute(TRACKINGELEMENT_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)trackingelement) && StringUtils.isNotBlank((CharSequence)(trackingEvent = this.element().getAttribute(TRACKING_EVENT_ATTRIBUTE)))) {
            JsonNode jsonNode = null;
            try {
                jsonNode = new ObjectMapper().readTree(trackingEvent);
            }
            catch (IOException e) {
                LOG.warn("Not a json string", (Throwable)e);
            }
            if (jsonNode != null) {
                trackingelement = jsonNode.get("element").asText();
            }
        }
        return trackingelement;
    }

    public String getAction() {
        return this.element().getAttribute(COLLECTION_ACTION_ATTRIBUTE);
    }
}

