/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelect;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class PolicyDialog
extends Dialog {
    private static final String CSS_SELECTOR = "coral-dialog";
    private static final String CANCEL_CSS = "button.cq-dialog-cancel";
    private static final String DONE_CSS = "button.cq-dialog-submit";
    private static final String POLICY_CREATE_CSS = "button.js-Policy-create";
    private static final String POLICY_DUPLICATE_CSS = "button.js-Policy-duplicate";
    private static final String EDIT_DESIGN_CSS = "button[trackingelement='edit design']";
    private ActionComponent<Dialog> editDesignButton = new ActionComponent<Object>(Selenide.$((String)"button[trackingelement='edit design']"), () -> new Dialog(), false);
    CoralSelect policySelect = new CoralSelect("placeholder=\"New policy\"");
    private SelenideElement cancelButton = Selenide.$((String)"button.cq-dialog-cancel");
    private SelenideElement doneButton = Selenide.$((String)"button.cq-dialog-submit");
    private SelenideElement policyCreateButton = Selenide.$((String)"button.js-Policy-create");
    private SelenideElement policyDuplicateButton = Selenide.$((String)"button.js-Policy-duplicate");
    private static final SelenideElement TITLE_FIELD = new FormField("./jcr:title").getFullyDecoratedElement("coral-dialog.is-open input", new String[0]);
    private static final SelenideElement DESCRIPTION_FIELD = new FormField("./jcr:description").getFullyDecoratedElement("coral-dialog.is-open textarea", new String[0]);

    public PolicyDialog() {
        super(CSS_SELECTOR);
    }

    public SelenideElement getEditDesignButton() {
        return this.editDesignButton.element();
    }

    public CoralSelect getPolicySelect() {
        return this.policySelect;
    }

    public SelenideElement getCancelButton() {
        return this.cancelButton;
    }

    public SelenideElement getDoneButton() {
        return this.doneButton;
    }

    public Dialog clickEditDesign() {
        return Helpers.clickDialogAction(this.editDesignButton);
    }

    public PolicyDialog selectPolicy(String policyPath) {
        this.getPolicySelect().selectItemByValue(policyPath);
        this.waitPageUnmasked();
        return this;
    }

    public PolicyDialog clickCancel() {
        return this.clickButton(this.cancelButton);
    }

    public PolicyDialog clickDone() {
        return this.clickButton(this.doneButton);
    }

    public PolicyDialog clickPolicyCreate() {
        return this.clickPolicyButton(this.policyCreateButton);
    }

    public PolicyDialog clickPolicyDuplicate() {
        return this.clickPolicyButton(this.policyDuplicateButton);
    }

    public PolicyDialog clickButton(SelenideElement button) {
        ElementUtils.clickableClick(button.shouldBe(new Condition[]{Condition.visible, Condition.enabled}));
        this.waitVanish();
        return this;
    }

    public PolicyDialog clickPolicyButton(SelenideElement button) {
        ElementUtils.clickableClick(button.shouldBe(new Condition[]{Condition.visible, Condition.enabled}));
        Helpers.waitDOMIdled(250L);
        this.waitPageUnmasked();
        return this;
    }

    public SelenideElement policyTitle() {
        return TITLE_FIELD;
    }

    public SelenideElement policyDescription() {
        return DESCRIPTION_FIELD;
    }
}

