/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite.columnview;

import com.adobe.cq.testing.selenium.Constants;
import com.codeborne.selenide.Selenide;

public class ColumnViewItem {
    private final String itemSelector;
    private final String previewSelector;

    public ColumnViewItem(String collectionSelector, String relId) {
        this.itemSelector = collectionSelector + " coral-columnview-item[data-foundation-collection-item-id='" + relId + "']";
        this.previewSelector = collectionSelector + " coral-columnview-preview[data-foundation-layout-columnview-columnid='" + relId + "']";
    }

    public void waitForPreview() {
        Selenide.$((String)this.previewSelector).shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
    }

    public boolean previewIsVisible() {
        return Selenide.$((String)this.previewSelector).isDisplayed();
    }

    public boolean isVisible() {
        return Selenide.$((String)this.itemSelector).isDisplayed();
    }

    public boolean isParent() {
        return Selenide.$((String)(this.itemSelector + "[variant='drilldown']")).exists();
    }

    public void select() {
        if (Selenide.$((String)(this.itemSelector + "[selected='true']")).exists()) {
            return;
        }
        Selenide.$((String)(this.itemSelector + " coral-columnview-item-thumbnail")).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public void deselect() {
        if (!Selenide.$((String)(this.itemSelector + "[selected='true']")).exists()) {
            return;
        }
        Selenide.$((String)(this.itemSelector + " coral-columnview-item-thumbnail")).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }

    public void activate() {
        Selenide.$((String)this.itemSelector).should(Constants.EXISTS_ENABLED_VISIBLE).click();
    }
}

