/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.history.impl;

import com.adobe.cq.history.api.HistoryEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryEntryImpl
implements HistoryEntry {
    private static final Logger log = LoggerFactory.getLogger(HistoryEntryImpl.class);
    private static final Pattern LOG_PATTERN = Pattern.compile("^(.+\\s.+)\\s(.+)\\s(.+)\\s\\[(.+)\\]\\s\\[(.+)\\]$");
    private final String resourcePath;
    private final Set<String> resourceTypes = new HashSet<String>();
    private final HistoryEntry.Action action;
    private final String userId;
    private final Calendar date;

    HistoryEntryImpl(Resource resource, HistoryEntry.Action action, String userId) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource should not be null");
        }
        this.resourcePath = resource.getPath();
        this.action = action;
        this.userId = userId;
        this.date = null;
        this.initResourceTypes(resource);
    }

    HistoryEntryImpl(String resourcePath, String[] resourceTypes, HistoryEntry.Action action, String userId, Calendar date) {
        this.resourcePath = resourcePath;
        this.action = action;
        this.userId = userId;
        this.date = date;
        this.initResourceTypes(resourceTypes);
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public HistoryEntry.Action getAction() {
        return this.action;
    }

    @Override
    public Calendar getDate() {
        return this.date;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public int compareTo(HistoryEntry historyEntry) {
        if (historyEntry == null) {
            return 1;
        }
        int c = this.getUserId().compareTo(historyEntry.getUserId());
        if (c != 0) {
            return c;
        }
        c = this.getResourcePath().compareTo(historyEntry.getResourcePath());
        return c;
    }

    public static HistoryEntry fromRequest(SlingHttpServletRequest request, Collection<String> resourceTypes) {
        boolean isFiltered = !resourceTypes.isEmpty();
        boolean doLog = !isFiltered;
        Resource resource = request.getResource();
        if (isFiltered) {
            for (String rt : resourceTypes) {
                if (!resource.isResourceType(rt)) continue;
                doLog = true;
                break;
            }
        }
        if (doLog) {
            return new HistoryEntryImpl(resource, request.getMethod().equalsIgnoreCase("post") ? HistoryEntry.Action.EDIT : HistoryEntry.Action.VIEW, request.getRemoteUser());
        }
        log.debug("Skipped resource: {}", (Object)resource.getPath());
        return null;
    }

    public static HistoryEntry fromFile(String logLine) throws ParseException {
        Matcher matcher;
        if (logLine.length() > 0 && (matcher = LOG_PATTERN.matcher(logLine)).matches()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Calendar date = Calendar.getInstance();
            date.setTime(dateFormat.parse(matcher.group(1)));
            return new HistoryEntryImpl(matcher.group(4), matcher.group(5).split(","), HistoryEntry.Action.valueOf(matcher.group(2)), matcher.group(3), date);
        }
        return null;
    }

    private void initResourceTypes(Resource resource) {
        this.resourceTypes.add(resource.getResourceType());
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                this.resourceTypes.add(node.getPrimaryNodeType().getName());
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            try {
                for (NodeType mixin : node.getMixinNodeTypes()) {
                    this.resourceTypes.add(mixin.getName());
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    private void initResourceTypes(String[] resourceTypes) {
        this.resourceTypes.addAll(Arrays.asList(resourceTypes));
    }
}

