/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.history.impl;

import com.adobe.cq.history.api.HistoryEntry;
import com.adobe.cq.history.api.HistoryService;
import com.adobe.cq.history.impl.HistoryEntryImpl;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import java.util.Iterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={EventHandler.class})
@Properties(value={@Property(name="event.topics", propertyPrivate=true, value={"com/day/cq/wcm/core/page", "com/day/cq/dam"})})
public class HistoryEventHandler
implements EventHandler {
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    @Reference
    private HistoryService history = null;
    private static final Logger log = LoggerFactory.getLogger(HistoryEventHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            ResourceResolver resolver = null;
            try {
                resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
                if ("com/day/cq/wcm/core/page".equals(event.getTopic())) {
                    this.handlePageEvent(PageEvent.fromEvent((Event)event), resolver);
                } else if ("com/day/cq/dam".equals(event.getTopic())) {
                    this.handleDamEvent(DamEvent.fromEvent((Event)event), resolver);
                }
            }
            catch (LoginException e) {
                log.error("Unable to acquire resource resolver while handling event: {}", (Object)event, (Object)e);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
    }

    private void handlePageEvent(PageEvent pageEvent, ResourceResolver resolver) {
        try {
            if (pageEvent != null) {
                Iterator iter = pageEvent.getModifications();
                block6: while (iter.hasNext()) {
                    PageModification pm = (PageModification)iter.next();
                    switch (pm.getType()) {
                        case MOVED: {
                            Resource resource = resolver.getResource(pm.getDestination());
                            if (resource == null) continue block6;
                            this.history.log(new HistoryEntryImpl(resource, HistoryEntry.Action.EDIT, pm.getUserId()));
                            continue block6;
                        }
                        case CREATED: 
                        case MODIFIED: 
                        case VERSION_CREATED: 
                        case RESTORED: {
                            Resource resource = resolver.getResource(pm.getPath());
                            if (resource == null) continue block6;
                            this.history.log(new HistoryEntryImpl(resource, HistoryEntry.Action.EDIT, pm.getUserId()));
                            continue block6;
                        }
                    }
                    log.debug("Received PageEvent of type {}: nothing to do", (Object)pm.getType());
                }
            }
        }
        catch (Exception e) {
            log.error("Exception during process of event {}", (Throwable)e);
        }
    }

    private void handleDamEvent(DamEvent damEvent, ResourceResolver resolver) {
        block6: {
            try {
                if (damEvent == null) break block6;
                switch (damEvent.getType()) {
                    case VERSIONED: 
                    case RESTORED: 
                    case METADATA_UPDATED: 
                    case ORIGINAL_UPDATED: 
                    case RENDITION_UPDATED: 
                    case RENDITION_REMOVED: 
                    case SUBASSET_UPDATED: 
                    case SUBASSET_REMOVED: 
                    case ASSET_CREATED: 
                    case ASSET_MOVED: {
                        Resource resource = resolver.getResource(damEvent.getAssetPath());
                        if (resource != null) {
                            this.history.log(new HistoryEntryImpl(resource, HistoryEntry.Action.EDIT, damEvent.getUserId()));
                        }
                        break;
                    }
                    default: {
                        log.debug("Received DamEvent of type {}: nothing to do", (Object)damEvent.getType());
                    }
                }
            }
            catch (Exception e) {
                log.error("Exception during process of event {}", (Throwable)e);
            }
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindHistory(HistoryService historyService) {
        this.history = historyService;
    }

    protected void unbindHistory(HistoryService historyService) {
        if (this.history == historyService) {
            this.history = null;
        }
    }
}

