/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.history.impl;

import com.adobe.cq.history.api.HistoryService;
import com.adobe.cq.history.impl.HistoryEntryImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%history.requestFilter.name", description="%history.requestFilter.description")
@Service(value={Filter.class})
@Properties(value={@Property(name="filter.scope", value={"request"}, propertyPrivate=true), @Property(name="filter.order", intValue={-2000}, propertyPrivate=true)})
public class HistoryRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HistoryRequestFilter.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private HistoryService history;
    private Collection<String> excludedSelectors = new HashSet<String>();
    private Collection<String> excludedExtensions = new HashSet<String>();
    @Property(unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_EXCLUDED_SELECTORS = "history.requestFilter.excludedSelectors";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_EXCLUDED_EXTENSIONS = "history.requestFilter.excludedExtensions";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            RequestPathInfo requestPathInfo = slingRequest.getRequestPathInfo();
            boolean excluded = false;
            String selectors = requestPathInfo.getSelectorString();
            if (StringUtils.isNotEmpty((String)selectors)) {
                for (String excludedSelector : this.excludedSelectors) {
                    if (selectors.indexOf(excludedSelector) == -1) continue;
                    excluded = true;
                    break;
                }
            }
            if (!excluded && !this.excludedExtensions.contains(requestPathInfo.getExtension())) {
                this.history.log(HistoryEntryImpl.fromRequest((SlingHttpServletRequest)request, this.history.getResourceTypes()));
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    @Activate
    void activate(ComponentContext ctx) {
        this.excludedSelectors.clear();
        this.excludedSelectors.addAll(Arrays.asList(PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_EXCLUDED_SELECTORS), (String[])new String[0])));
        this.excludedExtensions.clear();
        this.excludedExtensions.addAll(Arrays.asList(PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_EXCLUDED_EXTENSIONS), (String[])new String[0])));
    }

    protected void bindHistory(HistoryService historyService) {
        this.history = historyService;
    }

    protected void unbindHistory(HistoryService historyService) {
        if (this.history == historyService) {
            this.history = null;
        }
    }
}

