/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.history.impl;

import com.adobe.cq.history.api.HistoryEntry;
import com.adobe.cq.history.api.HistoryService;
import com.adobe.cq.history.impl.HistoryEntryImpl;
import com.adobe.cq.history.utils.ReverseFileReader;
import com.day.cq.commons.Filter;
import com.day.jcr.vault.fs.api.PathFilter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.filter.DefaultPathFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%history.service.name", description="%history.service.description", policy=ConfigurationPolicy.REQUIRE)
@Service
public class HistoryServiceImpl
implements HistoryService {
    private static final Logger log = LoggerFactory.getLogger(HistoryServiceImpl.class);
    private BundleContext bundleContext;
    private Logger historyLog = null;
    private Collection<String> resourceTypes = new HashSet<String>();
    private DefaultWorkspaceFilter writeFilter;
    private static final String DEFAULT_LOGGER = "log.history";
    @Property(value={"log.history"}, propertyPrivate=true)
    public static final String PROP_LOGGER = "history.sevice.logger";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_RESOURCE_TYPES = "history.service.resourceTypes";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_PATH_FILTER = "history.service.pathFilter";

    @Override
    public Collection<String> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public void log(HistoryEntry historyEntry) {
        if (historyEntry != null && (this.writeFilter == null || this.writeFilter.contains(historyEntry.getResourcePath()))) {
            this.historyLog.info(MarkerFactory.getMarker((String)historyEntry.getAction().toString()), "{} [{}] [{}]", new Object[]{historyEntry.getUserId(), historyEntry.getResourcePath(), StringUtils.join(historyEntry.getResourceTypes(), (String)",")});
        }
    }

    @Override
    public Collection<HistoryEntry> readEntries(ResourceResolver resolver, String userId, int maxCount) {
        return this.readEntries(resolver, userId, maxCount, null);
    }

    @Override
    public Collection<HistoryEntry> readEntries(ResourceResolver resolver, String userId, int maxCount, Filter<HistoryEntry> filter) {
        ArrayList<HistoryEntry> historyEntries = new ArrayList<HistoryEntry>();
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        try {
            Authorizable user = userManager.getAuthorizable(userId);
            userId = user != null && !user.isGroup() ? user.getID() : null;
        }
        catch (RepositoryException e) {
            log.error("Unable to get user from user manager", (Throwable)e);
        }
        if (userId != null) {
            File folder = new File(this.bundleContext.getProperty("sling.home"), "logs");
            File[] files = folder.listFiles(new FilenameFilter(){

                public boolean accept(File folder, String fileName) {
                    File file = new File(folder, fileName);
                    return file.isFile() && fileName.startsWith("history.log");
                }
            });
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return -Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
            TreeSet<HistoryEntry> historyEntriesSet = new TreeSet<HistoryEntry>();
            int i = 0;
            for (int count = 0; i < files.length && count < maxCount; count += this.readFile(resolver, files[i], historyEntriesSet, userId, count, maxCount, filter), ++i) {
            }
            historyEntries.addAll(historyEntriesSet);
            Collections.sort(historyEntries, new Comparator<HistoryEntry>(){

                @Override
                public int compare(HistoryEntry he1, HistoryEntry he2) {
                    return -he1.getDate().compareTo(he2.getDate());
                }
            });
        }
        return historyEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFile(ResourceResolver resolver, File file, SortedSet<HistoryEntry> historyEntries, String userId, int count, int maxCount, Filter<HistoryEntry> filter) {
        ReverseFileReader reader = null;
        try {
            String line;
            reader = new ReverseFileReader(file, "UTF-8");
            while (count < maxCount && (line = reader.readLine()) != null) {
                try {
                    HistoryEntry historyEntry = HistoryEntryImpl.fromFile(line);
                    if (historyEntry == null || !historyEntry.getUserId().equals(userId) || filter != null && !filter.includes((Object)historyEntry) || resolver.getResource(historyEntry.getResourcePath()) == null || !historyEntries.add(historyEntry)) continue;
                    ++count;
                }
                catch (ParseException e) {
                    log.warn("Unable to parse log entry from line: {}", (Object)line);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error("File not found", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to read file", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return count;
    }

    @Activate
    void activate(BundleContext bundleContext, Map<String, Object> props) {
        this.bundleContext = bundleContext;
        this.historyLog = LoggerFactory.getLogger((String)PropertiesUtil.toString((Object)props.get(PROP_LOGGER), (String)DEFAULT_LOGGER));
        this.resourceTypes.clear();
        this.resourceTypes.addAll(Arrays.asList(PropertiesUtil.toStringArray((Object)props.get(PROP_RESOURCE_TYPES), (String[])new String[0])));
        String[] filterPaths = PropertiesUtil.toStringArray((Object)props.get(PROP_PATH_FILTER), null);
        if (filterPaths != null) {
            this.writeFilter = new DefaultWorkspaceFilter();
            PathFilterSet set = new PathFilterSet("/");
            set.addExclude((com.day.jcr.vault.fs.api.Filter)PathFilter.ALL);
            for (String filterPath : filterPaths) {
                if (filterPath.startsWith("-")) {
                    set.addExclude((com.day.jcr.vault.fs.api.Filter)new DefaultPathFilter(filterPath.substring(1)));
                    continue;
                }
                if (filterPath.startsWith("+")) {
                    filterPath = filterPath.substring(1);
                }
                set.addInclude((com.day.jcr.vault.fs.api.Filter)new DefaultPathFilter(filterPath));
            }
            this.writeFilter.add(set);
        } else {
            this.writeFilter = null;
        }
    }
}

