/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.history.impl.timeline;

import com.adobe.cq.history.api.HistoryEntry;
import com.adobe.cq.history.api.HistoryService;
import com.adobe.cq.history.api.timeline.HistoryTimelineEventType;
import com.adobe.cq.history.impl.timeline.project.ProjectHistoryEntryFilter;
import com.adobe.cq.history.impl.timeline.project.ProjectUtil;
import com.adobe.granite.timeline.TimelineEvent;
import com.adobe.granite.timeline.TimelineEventProvider;
import com.adobe.granite.timeline.TimelineEventType;
import com.day.cq.wcm.api.Page;
import com.day.jcr.vault.util.Text;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
public class HistoryTimelineEventProvider
implements TimelineEventProvider {
    private static final Logger log = LoggerFactory.getLogger(HistoryTimelineEventProvider.class);
    @Reference
    private HistoryService history;
    public static final TimelineEventType EVENT_TYPE = new HistoryTimelineEventType(){

        public String getName() {
            return HistoryTimelineEventType.class.getCanonicalName();
        }
    };

    public boolean accepts(Resource resource) {
        return ProjectUtil.isProject(resource);
    }

    public Collection<TimelineEvent> getEvents(Resource resource) {
        ArrayList<TimelineEvent> events = new ArrayList<TimelineEvent>();
        ResourceResolver resolver = resource.getResourceResolver();
        long start = System.currentTimeMillis();
        Collection<HistoryEntry> historyEntries = this.history.readEntries(resolver, ((Session)resolver.adaptTo(Session.class)).getUserID(), 10, new ProjectHistoryEntryFilter(resource));
        log.debug(">>> retrieved all history entries for resource [{}] in [{}ms]", (Object)resource.getPath(), (Object)(System.currentTimeMillis() - start));
        long startTimelineEntries = System.currentTimeMillis();
        for (HistoryEntry historyEntry : historyEntries) {
            events.add(new HistoryTimelineEvent(historyEntry, resolver));
        }
        log.debug(">>> converted history entries to timeline events for resource [{}] took [{}ms]", (Object)resource.getPath(), (Object)(System.currentTimeMillis() - startTimelineEntries));
        return events;
    }

    public TimelineEventType getType() {
        return EVENT_TYPE;
    }

    protected void bindHistory(HistoryService historyService) {
        this.history = historyService;
    }

    protected void unbindHistory(HistoryService historyService) {
        if (this.history == historyService) {
            this.history = null;
        }
    }

    private static class HistoryTimelineEvent
    implements TimelineEvent {
        private final HistoryEntry historyEntry;
        private final ResourceResolver resolver;

        public HistoryTimelineEvent(HistoryEntry historyEntry, ResourceResolver resolver) {
            this.historyEntry = historyEntry;
            this.resolver = resolver;
        }

        public String getAction() {
            return this.historyEntry.getAction().name();
        }

        public String getDescription() {
            Page historyPage;
            Resource historyRes = this.resolver.getResource(this.historyEntry.getResourcePath());
            if (historyRes != null && this.historyEntry.getResourceTypes().contains("cq:Page") && (historyPage = (Page)historyRes.adaptTo(Page.class)) != null && StringUtils.isNotEmpty((String)historyPage.getTitle())) {
                return historyPage.getTitle();
            }
            return Text.getName((String)this.historyEntry.getResourcePath());
        }

        public String getOrigin() {
            return this.historyEntry.getResourcePath();
        }

        public long getTime() {
            return this.historyEntry.getDate().getTimeInMillis();
        }

        public TimelineEventType getType() {
            return EVENT_TYPE;
        }

        public String getUserID() {
            return this.historyEntry.getUserId();
        }
    }
}

