/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationClient
extends CQClient {
    private static final Logger log = LoggerFactory.getLogger(ReplicationClient.class);
    public static final String AUTHOR_GROUP_PATH = "/etc/replication/agents.author";
    public static final String PUBLISH_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish";
    public static final String PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish_reverse";
    private static final String SYSTEM_USE_DISTRIBUTION = "granite.it.useDistribution";
    private static final boolean isDistribution = "true".equals(System.getProperty("granite.it.useDistribution", null));

    public ReplicationClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public ReplicationClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse activate(String nodePath, int ... expectedStatus) throws ClientException {
        return this.doPost("/bin/replicate.json", (HttpEntity)FormEntityBuilder.create().addParameter("cmd", "Activate").addParameter("_charset_", "utf-8").addParameter("path", nodePath).build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deactivate(String pagePath, int ... expectedStatus) throws ClientException {
        return this.doPost("/bin/replicate.json", (HttpEntity)FormEntityBuilder.create().addParameter("cmd", "Deactivate").addParameter("_charset_", "utf-8").addParameter("path", pagePath).build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse activateLater(String nodePath, long timeMilliseconds, int ... expectedStatus) throws ClientException {
        Calendar now = Calendar.getInstance();
        long currentTime = now.getTimeInMillis();
        long scheduledTime = currentTime + timeMilliseconds;
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("model", "/etc/workflow/models/scheduled_activation/jcr:content/model").addParameter("_charset_", "utf-8").addParameter("absoluteTime", Long.toString(scheduledTime)).addParameter("payload", nodePath).addParameter("payloadType", "JCR_PATH").build();
        return this.doPost("/etc/workflow/instances", (HttpEntity)entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deactivateLater(String nodePath, long timeMilliseconds, int ... expectedStatus) throws ClientException {
        Calendar now = Calendar.getInstance();
        long currentTime = now.getTimeInMillis();
        long scheduledTime = currentTime + timeMilliseconds;
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("model", "/etc/workflow/models/scheduled_deactivation/jcr:content/model").addParameter("_charset_", "utf-8").addParameter("absoluteTime", Long.toString(scheduledTime)).addParameter("payload", nodePath).addParameter("payloadType", "JCR_PATH").build();
        return this.doPost("/etc/workflow/instances", (HttpEntity)entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public JsonNode createReplicationAgent(String name, String title, String parentPath, String template, BasicNameValuePair ... properties) throws ClientException, InterruptedException {
        SlingHttpResponse page = this.createPage(name, title, parentPath, template, 201, 200);
        String agentPath = page.getSlingPath();
        return this.adaptReplicationAgent(agentPath, properties);
    }

    public JsonNode adaptReplicationAgent(final String agentPath, BasicNameValuePair ... properties) throws ClientException, InterruptedException {
        if ("".equals(agentPath) || agentPath == null) {
            throw new IllegalArgumentException("agentPath may not be null.");
        }
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addAllParameters(Arrays.asList(properties)).build();
        try {
            new Polling((HttpEntity)entity){
                final /* synthetic */ HttpEntity val$entity;
                {
                    this.val$entity = httpEntity;
                }

                public Boolean call() throws Exception {
                    ReplicationClient.this.doPost(agentPath + "/jcr:content", this.val$entity, new int[]{200});
                    return true;
                }
            }.poll(10000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to adapt replication agent" + agentPath, (Throwable)e);
        }
        return this.doGetJson(agentPath, -1, new int[0]).get("jcr:content");
    }

    public JsonNode getAgentReplicationQueue(String agentPath) throws ClientException, InterruptedException {
        try {
            this.waitExists(agentPath + "/_jcr_content.queue", 5000L, 500L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to retrieve queue for replication agent " + agentPath, (Throwable)e);
        }
        return this.doGetJson(agentPath + "/_jcr_content.queue", -1, new int[]{200}).get("queue");
    }

    public JsonNode getPublishReplicationQueue() throws ClientException, InterruptedException {
        return this.getAgentReplicationQueue(PUBLISH_REPLICATION_DEFAULT_AGENT);
    }

    public JsonNode getReverseReplicationQueue() throws ClientException, InterruptedException {
        return this.getAgentReplicationQueue(PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT);
    }

    public void waitAgentReplicationQueueIsEmpty(String agentPath) throws InterruptedException, ClientException {
        try {
            this.getAgentReplicationQueue(agentPath);
        }
        catch (ClientException e) {
            throw new ClientException("Could not access the Queue for Replication Agent " + agentPath, (Throwable)e);
        }
        EmptyReplicationQueuePoller polling = new EmptyReplicationQueuePoller(this, agentPath);
        try {
            polling.poll(2000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("The queue for replication agent " + agentPath + "was not empty after " + polling.getWaited() + ". It still contains " + polling.queue.size() + "elements: \n" + polling.queue.toString());
        }
    }

    public void waitPublishReplicationQueueIsEmpty() throws InterruptedException, ClientException {
        this.waitAgentReplicationQueueIsEmpty(PUBLISH_REPLICATION_DEFAULT_AGENT);
    }

    public void waitReversePublishReplicationQueueIsEmpty() throws InterruptedException, ClientException {
        this.waitAgentReplicationQueueIsEmpty(PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT);
    }

    public boolean isConnectionSuccessful(String agentLocation) throws ClientException {
        SlingHttpResponse exec = this.doGet(agentLocation + ".test.html", new int[]{200});
        return exec.getContent().contains("succeeded");
    }

    public boolean findInLog(String agentLocation, String[] patterns, Date startTime) throws ClientException {
        String[] lines;
        SlingHttpResponse exec = this.doGet(agentLocation + ".log.html", new int[]{200});
        String content = exec.getContent();
        for (String line : lines = content.split("\n")) {
            if (line.length() < 20) continue;
            String time = line.substring(0, 19);
            try {
                SimpleDateFormat logDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                Date convertedLogDate = logDate.parse(time);
                if (!convertedLogDate.equals(startTime) && !convertedLogDate.after(startTime)) continue;
                for (String pattern : patterns) {
                    if (!line.contains(pattern)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static class EmptyReplicationQueuePoller
    extends Polling {
        private final ReplicationClient client;
        private final String agentPath;
        private JsonNode queue;

        public EmptyReplicationQueuePoller(ReplicationClient client, String agentPath) {
            this.client = client;
            this.agentPath = agentPath;
        }

        public Boolean call() throws Exception {
            this.queue = this.client.getAgentReplicationQueue(this.agentPath);
            return !this.queue.getElements().hasNext();
        }
    }
}

