/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.notification;

import com.adobe.cq.testing.client.CQClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonNode;

public class Notification {
    public static final String NOTIFICATION_COMMAND_APPROVE = "approve";
    public static final String NOTIFICATION_COMMAND_DELETE = "delete";
    protected String id = "";
    protected String modification = "";
    protected String path = "";
    protected Date date;
    protected boolean isRead;
    protected boolean isUserMessage;
    protected String user;

    public Notification(JsonNode jsonNotification) {
        this.id = jsonNotification.get("id").getTextValue();
        this.modification = jsonNotification.get("modification").getTextValue();
        this.path = jsonNotification.get("path").getTextValue();
        this.isRead = jsonNotification.get("isRead").getBooleanValue();
        this.isUserMessage = jsonNotification.get("isUserMessage").getBooleanValue();
        this.user = jsonNotification.get("user").getTextValue();
        String d = jsonNotification.get("date").getTextValue();
        try {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            this.date = format.parse(d);
        }
        catch (ParseException e) {
            this.date = null;
        }
    }

    public Notification(CQClient client, String id, String modification, String path, Date date, boolean isRead, boolean isUserMessage, String user) {
        this.id = id;
        this.modification = modification;
        this.path = path;
        this.date = date;
        this.isRead = isRead;
        this.isUserMessage = isUserMessage;
        this.user = user;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModification() {
        return this.modification;
    }

    public void setModification(String modification) {
        this.modification = modification;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public boolean isUserMessage() {
        return this.isUserMessage;
    }

    public void setUserMessage(boolean isUserMessage) {
        this.isUserMessage = isUserMessage;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isRead ? 1231 : 1237);
        result = 31 * result + (this.isUserMessage ? 1231 : 1237);
        result = 31 * result + (this.modification == null ? 0 : this.modification.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isRead != other.isRead) {
            return false;
        }
        if (this.isUserMessage != other.isUserMessage) {
            return false;
        }
        if (this.modification == null ? other.modification != null : !this.modification.equals(other.modification)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

