/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.assertion;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.JsonClient;
import com.adobe.cq.testing.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;

public class CQAssert {
    public static void assertCQPageExistsWithTimeout(final CQClient client, final String path, long timeout, long delay) throws InterruptedException {
        try {
            new Polling(){

                public Boolean call() {
                    try {
                        CQAssert.assertIsCQPage(client, path);
                        return true;
                    }
                    catch (Throwable e) {
                        return false;
                    }
                }
            }.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            Assert.fail((String)("Timeout reached while waiting for CQ page " + path));
        }
    }

    public static void assertPathDoesNotExistWithTimeout(final CQClient client, final String path, long timeout, long delay) throws InterruptedException {
        try {
            new Polling(){

                public Boolean call() {
                    try {
                        return !client.exists(path);
                    }
                    catch (Throwable e) {
                        return false;
                    }
                }
            }.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            Assert.fail((String)("Timeout reached while waiting for path to be deleted: " + path));
        }
    }

    public static void assertFolderExists(CQClient client, String path, String folderTitle) {
        JsonNode rootNode = null;
        try {
            rootNode = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(path, 1, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + path + " failed!"));
        }
        String primaryType = rootNode.get("jcr:primaryType").getValueAsText();
        Assert.assertTrue((String)("jcr:primaryType of folder node " + path + " is neither sling:OrderedFolder nor Sling:Folder"), ("sling:OrderedFolder".equals(primaryType) || "sling:Folder".equals(primaryType) ? 1 : 0) != 0);
        Assert.assertTrue((String)("No jcr:content node found below " + path + "!"), (!rootNode.path("jcr:content").isMissingNode() ? 1 : 0) != 0);
        JsonNode contentNode = rootNode.path("jcr:content");
        Assert.assertEquals((String)("jcr:primaryType of jcr:content node below " + path + " is not set to nt:unstructured!"), (Object)"nt:unstructured", (Object)contentNode.get("jcr:primaryType").getTextValue());
        Assert.assertNotNull((String)("jcr:title property is not set in jcr:content node below " + path + "!"), (Object)contentNode.get("jcr:title"));
        Assert.assertEquals((String)("jcr:title of jcr:content node below " + path + " is not set folder title " + folderTitle + "!"), (Object)folderTitle, (Object)contentNode.get("jcr:title").getTextValue());
    }

    public static void assertFileExists(CQClient client, String path, InputStream fileData, String mimeType) {
        JsonNode node = null;
        try {
            node = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(path, -1, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + path + " failed"));
        }
        Assert.assertEquals((String)("jcr:primaryType of folder node " + path + " is not set to sling:OrderedFolder!"), (Object)"sling:OrderedFolder", (Object)node.get("jcr:primaryType").getValueAsText());
        Assert.assertTrue((String)("No file node found below " + path + "!"), (!node.path("file").isMissingNode() ? 1 : 0) != 0);
        node = node.path("file");
        path = path + "/file";
        Assert.assertEquals((String)("jcr:primaryType of file node below " + path + " is not set to nt:file!"), (Object)"nt:file", (Object)node.get("jcr:primaryType").getTextValue());
        Assert.assertTrue((String)("No jcr:content node found below " + path + "!"), (!node.path("jcr:content").isMissingNode() ? 1 : 0) != 0);
        node = node.path("jcr:content");
        path = path + "/jcr:content";
        Assert.assertEquals((String)("jcr:mimeType is not set to " + mimeType), (Object)mimeType, (Object)node.get("jcr:mimeType").getTextValue());
        Assert.assertEquals((String)("jcr:primaryType of jcr:content node below " + path + " is not set to nt:resource!"), (Object)"nt:resource", (Object)node.get("jcr:primaryType").getTextValue());
        try {
            InputStream in = client.doStreamGet(path, null, null, new int[0]).getEntity().getContent();
            Assert.assertTrue((String)"The original file and the requested file are not the same", (boolean)TestUtil.binaryCompare(fileData, in));
        }
        catch (IOException | ClientException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void assertAssetExists(CQClient client, String path, InputStream fileData, String mimeType) {
        JsonNode node = null;
        try {
            node = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(path, -1, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + path + " failed!"));
        }
        Assert.assertEquals((String)("jcr:primaryType of folder node " + path + " is not set to dam:Asset!"), (Object)"dam:Asset", (Object)node.get("jcr:primaryType").getValueAsText());
        Assert.assertTrue((String)("No jcr:content node found below " + path + "!"), (!node.path("jcr:content").isMissingNode() ? 1 : 0) != 0);
        node = node.path("jcr:content");
        path = path + "/jcr:content";
        Assert.assertEquals((String)("jcr:primaryType of jcr:content node below " + path + " is not set to dam:AssetContent!"), (Object)"dam:AssetContent", (Object)node.get("jcr:primaryType").getTextValue());
        Assert.assertTrue((String)("No metadata node found below " + path + "!"), (!node.path("metadata").isMissingNode() ? 1 : 0) != 0);
        Assert.assertTrue((String)("No renditions folder found below " + path + "!"), (!node.path("renditions").isMissingNode() ? 1 : 0) != 0);
        node = node.path("renditions");
        path = path + "/renditions";
        Assert.assertTrue((String)("No original folder found below " + path + "!"), (!node.path("original").isMissingNode() ? 1 : 0) != 0);
        node = node.path("original");
        path = path + "/original";
        Assert.assertEquals((String)("jcr:primaryType of node  " + path + " is not set to nt:file!"), (Object)"nt:file", (Object)node.get("jcr:primaryType").getTextValue());
        Assert.assertTrue((String)("No jcr:content node found below " + path + "!"), (!node.path("jcr:content").isMissingNode() ? 1 : 0) != 0);
        node = node.path("jcr:content");
        path = path + "/jcr:content";
        Assert.assertEquals((String)("jcr:mimeType is not set to " + mimeType), (Object)mimeType, (Object)node.get("jcr:mimeType").getTextValue());
        try {
            Assert.assertTrue((String)"The original file and the requested file are not the same", (boolean)TestUtil.binaryCompare(fileData, client.doStreamGet(path, null, null, new int[0]).getEntity().getContent()));
        }
        catch (Exception e) {
            Assert.fail((String)"Binary compare of files failed!");
        }
    }

    public static void assertIsCQPage(CQClient client, String path) {
        JsonNode rootNode = null;
        try {
            rootNode = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(path, 2, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + path + " failed!"));
        }
        Assert.assertEquals((String)("jcr:primaryType of page node " + path + " is not set to cq:Page!"), (Object)"cq:Page", (Object)rootNode.get("jcr:primaryType").getValueAsText());
        Assert.assertTrue((String)("No jcr:content node found below " + path + "!"), (!rootNode.path("jcr:content").isMissingNode() ? 1 : 0) != 0);
        JsonNode contentNode = rootNode.path("jcr:content");
        Assert.assertEquals((String)("jcr:primaryType of jcr:content node below " + path + " is not set to cq:PageContent!"), (Object)"cq:PageContent", (Object)contentNode.get("jcr:primaryType").getTextValue());
        Assert.assertNotNull((String)("cq:template property is not set in jcr:content node below " + path + "!"), (Object)contentNode.get("cq:template"));
        Assert.assertNotNull((String)("sling:resourceType is not set in jcr:content node below " + path + "!"), (Object)contentNode.get("sling:resourceType"));
    }

    public static void assertIsLiveSite(CQClient client, String newPath, String masterPath) {
        JsonNode rootNode = null;
        try {
            rootNode = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(newPath, 2, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + newPath + " failed!"));
        }
        JsonNode contentNode = rootNode.path("jcr:content");
        Assert.assertTrue((String)"No jcr:content node found!", (!contentNode.isMissingNode() ? 1 : 0) != 0);
        Assert.assertNotNull((String)"cq:lastRolledout is not set!", (Object)contentNode.get("cq:lastRolledout"));
        Assert.assertNotNull((String)"cq:lastRolledoutBy is not set!", (Object)contentNode.get("cq:lastRolledoutBy"));
        JsonNode liveSyncConfig = contentNode.path("cq:LiveSyncConfig");
        Assert.assertTrue((String)"No cq:LiveSyncConfig node found!", (!liveSyncConfig.isMissingNode() ? 1 : 0) != 0);
        Assert.assertEquals((String)"cq:master is not set correctly!", (Object)masterPath, (Object)liveSyncConfig.get("cq:master").getValueAsText());
        Assert.assertNotNull((String)"cq:isDeep is not set!", (Object)liveSyncConfig.get("cq:isDeep"));
    }

    public static void assertIsBluePrint(CQClient client, String path) {
        String[][] tabs;
        String[][] nodePath;
        JsonNode rootNode = null;
        try {
            rootNode = ((JsonClient)client.adaptTo(JsonClient.class)).doGetJson(path, 7, new int[0]);
        }
        catch (ClientException e) {
            Assert.fail((String)("Request for " + path + " failed!"));
        }
        JsonNode currentNode = rootNode.path("jcr:content");
        Assert.assertTrue((String)"No jcr:content node found!", (!currentNode.isMissingNode() ? 1 : 0) != 0);
        for (String[] child : nodePath = new String[][]{{"dialog", "cq:Dialog"}, {"items", "cq:WidgetCollection"}, {"tabs", "cq:TabPanel"}, {"items", "cq:WidgetCollection"}}) {
            currentNode = currentNode.path(child[0]);
            Assert.assertTrue((String)("No " + child[0] + " node found!"), (!currentNode.isMissingNode() ? 1 : 0) != 0);
            Assert.assertEquals((String)(child[0] + " is not of type " + child[1]), (Object)currentNode.get("jcr:primaryType").getValueAsText(), (Object)child[1]);
        }
        for (String[] child : tabs = new String[][]{{"tab_lan", "/libs/wcm/msm/templates/blueprint/defaults/language_tab.infinity.json"}, {"tab_chap", "/libs/wcm/msm/templates/blueprint/defaults/chapters_tab.infinity.json"}, {"tab_lc", "/libs/wcm/msm/templates/blueprint/defaults/livecopy_tab.infinity.json"}}) {
            JsonNode tab = currentNode.path(child[0]);
            Assert.assertTrue((String)("No " + child[0] + " node found!"), (!tab.isMissingNode() ? 1 : 0) != 0);
            Assert.assertEquals((String)(child[0] + " has wrong type."), (Object)tab.get("jcr:primaryType").getValueAsText(), (Object)"cq:Widget");
            Assert.assertEquals((String)(child[0] + " has wrong path property."), (Object)tab.get("path").getValueAsText(), (Object)child[1]);
        }
    }

    public static void assertIsVersionList(CQClient client, String jsonString) {
        JsonNode rootNode = null;
        try {
            rootNode = JsonUtils.getJsonNodeFromString((String)jsonString);
        }
        catch (ClientException e) {
            Assert.fail((String)"Parsing of JSON String failed!");
        }
        JsonNode versions = rootNode.path("versions");
        Assert.assertTrue((String)"versions node not found!", (!versions.isMissingNode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"versions node is not an array!", (boolean)versions.isArray());
        String[] properties = new String[]{"id", "label", "name", "title", "comment", "created", "deleted"};
        for (int i = 0; i < versions.size(); ++i) {
            JsonNode version = versions.get(i);
            for (String property : properties) {
                Assert.assertTrue((String)(property + " property node not found!"), (!version.get(property).isMissingNode() ? 1 : 0) != 0);
            }
        }
    }

    public static void assertIsVersionTree(CQClient client, String jsonString) {
        JsonNode rootNode = null;
        try {
            rootNode = JsonUtils.getJsonNodeFromString((String)jsonString);
        }
        catch (ClientException e) {
            Assert.fail((String)"Parsing of JSON String failed!");
        }
        Assert.assertTrue((String)"Version tree is not an array!", (boolean)rootNode.isArray());
        String[] properties = new String[]{"text", "date", "name", "id", "leaf", "label", "title", "deleted"};
        for (int i = 0; i < rootNode.size(); ++i) {
            JsonNode element = rootNode.get(i);
            for (String property : properties) {
                Assert.assertTrue((String)(property + " property node not found!"), (!element.get(property).isMissingNode() ? 1 : 0) != 0);
            }
        }
    }
}

