/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import org.apache.http.HttpRequestInterceptor;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.interceptors.FormBasedAuthInterceptor;
import org.apache.sling.testing.junit.rules.instance.ExistingInstance;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassRuleUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ClassRuleUtils.class);
    public static final String LOGIN_TOKEN_AUTH = "it.logintokenauth";

    public static Instance newInstanceRule(boolean forceBasicAuth) {
        if (!forceBasicAuth && ClassRuleUtils.loginTokenAuth()) {
            LOG.info("Using LoginToken Auth as default");
            return new LoginTokenInstance();
        }
        LOG.info("Using Basic Auth as default");
        return new ExistingInstance();
    }

    public static Instance newInstanceRule() {
        return ClassRuleUtils.newInstanceRule(false);
    }

    public static boolean loginTokenAuth() {
        return Boolean.getBoolean(LOGIN_TOKEN_AUTH);
    }

    public static class LoginTokenInstance
    extends ExistingInstance {
        public <T extends SlingClient.InternalBuilder> T customize(T builder) {
            Registry authSchemeRegistry = RegistryBuilder.create().build();
            builder.httpClientBuilder().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
            builder.setPreemptiveAuth(false).addInterceptorFirst((HttpRequestInterceptor)new FormBasedAuthInterceptor("login-token"));
            return builder;
        }
    }
}

