/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.client.ReplicationClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplicationAgents
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReplicationAgents.class);
    private final Instance authorRule;
    private final Instance publishRule;

    public DefaultReplicationAgents(Instance authorRule, Instance publishRule) {
        this.authorRule = authorRule;
        this.publishRule = publishRule;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (DefaultReplicationAgents.this.configure()) {
                    DefaultReplicationAgents.this.configureReplicationAgents();
                }
                try {
                    base.evaluate();
                }
                finally {
                    DefaultReplicationAgents.this.cleanup();
                }
            }
        };
    }

    protected boolean configure() {
        return true;
    }

    protected void configureReplicationAgents() throws ClientException, InterruptedException {
        this.adaptDefaultReplicationAgents((ReplicationClient)this.authorRule.getAdminClient(ReplicationClient.class), this.publishRule.getConfiguration().getUrl().toString());
    }

    protected void cleanup() {
    }

    private void adaptDefaultReplicationAgents(ReplicationClient rClient, String serverUrl) throws ClientException, InterruptedException {
        rClient.adaptReplicationAgent(this.getReplicationAgent(), new BasicNameValuePair("enabled", "true"), new BasicNameValuePair("transportUri", serverUrl + "/bin/receive?sling:authRequestLogin=1"), new BasicNameValuePair("userId", rClient.getUser()), new BasicNameValuePair("transportUser", rClient.getUser()), new BasicNameValuePair("transportPassword", rClient.getPassword()));
        rClient.adaptReplicationAgent(this.getReverseReplicationAgent(), new BasicNameValuePair("enabled", "true"), new BasicNameValuePair("transportUri", serverUrl + "/bin/receive?sling:authRequestLogin=1"), new BasicNameValuePair("userId", rClient.getUser()), new BasicNameValuePair("transportUser", rClient.getUser()), new BasicNameValuePair("transportPassword", rClient.getPassword()));
        LOG.info("Replication agents on author ({}) adapted to publish ({})", (Object)rClient.getUrl(), (Object)serverUrl);
    }

    protected String getReplicationAgent() {
        return "/etc/replication/agents.author/publish";
    }

    protected String getReverseReplicationAgent() {
        return "/etc/replication/agents.author/publish_reverse";
    }
}

