/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import java.util.HashMap;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableOpenIndexAsync
implements TestRule {
    private static final String SERVICE_PID = "org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService";
    private static final String OPEN_INDEX_ASYNC_PROPERTY = "enableOpenIndexAsync";
    private boolean adapted = false;
    private final Instance quickstartRule;
    private static final Logger LOG = LoggerFactory.getLogger(DisableOpenIndexAsync.class);

    public DisableOpenIndexAsync(Instance quickstart) {
        this.quickstartRule = quickstart;
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (!DisableOpenIndexAsync.this.adapted) {
                    DisableOpenIndexAsync.this.adaptOSGiConfig();
                    DisableOpenIndexAsync.this.adapted = true;
                }
                statement.evaluate();
            }
        };
    }

    private void adaptOSGiConfig() {
        LOG.info("adapting OSGi config for org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService -> enableOpenIndexAsync");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(OPEN_INDEX_ASYNC_PROPERTY, "false");
        try {
            OsgiConsoleClient osgiClient = (OsgiConsoleClient)this.quickstartRule.getAdminClient(OsgiConsoleClient.class);
            osgiClient.editConfiguration(SERVICE_PID, null, props, new int[0]);
        }
        catch (ClientException e) {
            LOG.warn("No author instance found to adapt OSGi Config for org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService -> enableOpenIndexAsync");
        }
    }
}

