/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules.usepackage;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.PackageManagerClient;
import com.adobe.cq.testing.junit.rules.usepackage.UsePackageRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.runners.model.Statement;

public class UsingPackageStatement
extends Statement {
    private Statement base;
    private UsePackageRule rule;

    public UsingPackageStatement(UsePackageRule rule, Statement base) {
        this.base = base;
        this.rule = rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        PackageManagerClient.Package uploadedPackage = null;
        try {
            File packFile = this.generatePackage(this.rule.getSrcPath());
            CQClient adminAuthor = (CQClient)this.rule.getInstance().getAdminClient(CQClient.class);
            PackageManagerClient packClient = (PackageManagerClient)adminAuthor.adaptTo(PackageManagerClient.class);
            uploadedPackage = packClient.uploadPackage(new FileInputStream(packFile), packFile.getName());
            uploadedPackage.install();
            this.base.evaluate();
        }
        finally {
            if (uploadedPackage != null) {
                uploadedPackage.unInstall();
                uploadedPackage.delete();
            }
        }
    }

    private File generatePackage(String resourceFolder) throws IOException {
        URL res = ((Object)((Object)this)).getClass().getResource(resourceFolder);
        String srcPath = null;
        if (!res.toString().startsWith("jar:") && (srcPath = res.toString()).startsWith("file:")) {
            srcPath = srcPath.substring(5);
        }
        return this.buildJarFromFolder(srcPath);
    }

    private File buildJarFromFolder(String srcPath) throws IOException {
        File generatedPackage = File.createTempFile("temp-package-", ".zip");
        generatedPackage.deleteOnExit();
        Manifest man = new Manifest();
        Attributes atts = man.getMainAttributes();
        atts.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        atts.putValue("Build-Jdk", ManagementFactory.getRuntimeMXBean().getVmVersion());
        JarOutputStream outJar = new JarOutputStream((OutputStream)new FileOutputStream(generatedPackage), man);
        Iterator fileIter = FileUtils.iterateFilesAndDirs((File)new File(srcPath), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (fileIter.hasNext()) {
            File currFile = (File)fileIter.next();
            if (currFile.isDirectory()) continue;
            String entryName = currFile.getAbsolutePath().substring(srcPath.length() + 1);
            JarEntry je = new JarEntry(entryName);
            je.setTime(currFile.lastModified());
            je.setSize(currFile.length());
            outJar.putNextEntry(je);
            IOUtils.copy((InputStream)new FileInputStream(currFile), (OutputStream)outJar);
            outJar.closeEntry();
        }
        outJar.close();
        return generatedPackage;
    }
}

