/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraniteBackwardsCompatibility {
    private static final Logger LOG = LoggerFactory.getLogger(GraniteBackwardsCompatibility.class);

    public static void translateGranitePropertiesToSling() {
        String publishUrl;
        String authorUrl;
        for (String property : System.getProperties().stringPropertyNames()) {
            String slingProp;
            if (!property.startsWith("granite.it.") || System.getProperty(slingProp = property.replaceFirst("granite\\.it\\.", "sling.it.")) != null) continue;
            System.setProperty(slingProp, System.getProperty(property));
            LOG.info("Set {}={} from {}", new Object[]{slingProp, System.getProperty(slingProp), property});
        }
        String loginTokenAuth = System.getProperty("granite.it.logintokenauth");
        if (loginTokenAuth != null && System.getProperty("it.logintokenauth") == null) {
            System.setProperty("it.logintokenauth", loginTokenAuth);
        }
        if ((authorUrl = System.getProperty("granite.it.author.url")) != null && !GraniteBackwardsCompatibility.isInstanceAlreadyConfigured(authorUrl, "author")) {
            int instances = Integer.valueOf(System.getProperty("sling.it.instances", "0"));
            System.setProperty("sling.it.instance.url." + String.valueOf(instances + 1), authorUrl);
            System.setProperty("sling.it.instance.runmode." + String.valueOf(instances + 1), "author");
            System.setProperty("sling.it.instances", String.valueOf(instances + 1));
        }
        if ((publishUrl = System.getProperty("granite.it.publish.url")) != null && !GraniteBackwardsCompatibility.isInstanceAlreadyConfigured(publishUrl, "publish")) {
            int instances = Integer.valueOf(System.getProperty("sling.it.instances", "0"));
            System.setProperty("sling.it.instance.url." + String.valueOf(instances + 1), publishUrl);
            System.setProperty("sling.it.instance.runmode." + String.valueOf(instances + 1), "publish");
            System.setProperty("sling.it.instances", String.valueOf(instances + 1));
        }
    }

    private static boolean isInstanceAlreadyConfigured(String url, String runmode) {
        int instances = Integer.valueOf(System.getProperty("sling.it.instances", "0"));
        for (int i = 1; i <= instances; ++i) {
            String instanceUrl = System.getProperty("sling.it.instance.url." + String.valueOf(i));
            String instanceRunmode = System.getProperty("sling.it.instance.runmode." + String.valueOf(i));
            if (!"author".equals(instanceRunmode) || !url.equals(instanceUrl)) continue;
            return true;
        }
        return false;
    }
}

