/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class BulkEditorClient
extends CQClient {
    public BulkEditorClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public BulkEditorClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public JsonNode search(String rootPath, String queryParams, String[] cols) throws ClientException {
        ArrayList<String> augumentedCols = new ArrayList<String>(cols.length);
        for (String col : cols) {
            augumentedCols.add("jcr:content/" + col);
        }
        String columns = StringUtils.join(augumentedCols, (String)",");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("query", "path:" + rootPath + " " + queryParams));
        params.add(new BasicNameValuePair("tidy", "true"));
        params.add(new BasicNameValuePair("cols", columns));
        SlingHttpResponse exec = this.doGet("/etc/importers/bulkeditor/query.json", params, new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent()).path("hits");
    }

    public SlingHttpResponse importContent(String rootPath, String fileName, String resourceFile, int ... expectedStatus) throws ClientException {
        return this.importContent(rootPath, fileName, ResourceUtil.getResourceAsStream((String)resourceFile), expectedStatus);
    }

    public SlingHttpResponse importContent(String rootPath, String fileName, InputStream inputStream, int ... expectedStatus) throws ClientException {
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("./rootPath", rootPath).addBinaryBody("document", inputStream, ContentType.create((String)"text/tab-separated-values"), fileName).addTextBody("./contentMode", "on").addTextBody("document@TypeHint", "nt:file").build();
        return this.doPost("/etc/importers/bulkeditor/import", entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public String exportContent(String rootPath, String queryParams, String[] cols) throws ClientException {
        ArrayList<String> augumentedCols = new ArrayList<String>(cols.length);
        for (String col : cols) {
            augumentedCols.add("jcr:content/" + col);
        }
        String columns = StringUtils.join(augumentedCols, (String)",");
        URLParameterBuilder builder = URLParameterBuilder.create();
        builder.add("query", "path:" + rootPath + " " + queryParams);
        builder.add("tidy", "true");
        builder.add("cols", columns);
        builder.add("separator", "null");
        SlingHttpResponse exec = this.doGet("/etc/importers/bulkeditor/export.tsv", builder.getList(), new int[]{200});
        return exec.getContent();
    }

    public SlingHttpResponse changePropertyValue(String nodePath, String newValue, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("_charset_", "utf-8");
        form.addParameter(nodePath, newValue);
        return this.doPost("/", (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

