/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.jobs;

import org.codehaus.jackson.JsonNode;

public class TopicStat {
    String topicName;
    long lastActivated;
    long lastFinished;
    int finishedJobs;
    int failedJobs;
    int cancelledJobs;
    long avgProcessingTime;
    long avgWaitingTime;

    public TopicStat(String topicName, long lastActivated, long lastFinished, int finishedJobs, int failedJobs, int cancelledJobs, long avgProcessingTime, long avgWaitingTime) {
        this.topicName = topicName;
        this.lastActivated = lastActivated;
        this.lastFinished = lastFinished;
        this.finishedJobs = finishedJobs;
        this.failedJobs = failedJobs;
        this.cancelledJobs = cancelledJobs;
        this.avgProcessingTime = avgProcessingTime;
        this.avgWaitingTime = avgWaitingTime;
    }

    public TopicStat(JsonNode topicJson) {
        this.topicName = topicJson.get("topic").getTextValue();
        this.lastActivated = topicJson.get("last_activated").getLongValue();
        this.lastFinished = topicJson.get("last_finished").getLongValue();
        this.finishedJobs = topicJson.get("finished_jobs").getIntValue();
        this.failedJobs = topicJson.get("failed_jobs").getIntValue();
        this.cancelledJobs = topicJson.get("cancelled_jobs").getIntValue();
        this.avgProcessingTime = topicJson.get("avg_processing_time").getLongValue();
        this.avgWaitingTime = topicJson.get("avg_waiting_time").getLongValue();
    }

    public String getTopicName() {
        return this.topicName;
    }

    public long getLastActivated() {
        return this.lastActivated;
    }

    public long getLastFinished() {
        return this.lastFinished;
    }

    public int getFinishedJobs() {
        return this.finishedJobs;
    }

    public int getFailedJobs() {
        return this.failedJobs;
    }

    public int getCancelledJobs() {
        return this.cancelledJobs;
    }

    public long getAvgProcessingTime() {
        return this.avgProcessingTime;
    }

    public long getAvgWaitingTime() {
        return this.avgWaitingTime;
    }
}

