/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.junit.rules.CQClassRule;
import com.adobe.cq.testing.junit.rules.ClassRuleUtils;
import com.adobe.cq.testing.junit.rules.DefaultReplicationAgents;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CQAuthorPublishClassRule
implements TestRule {
    public final CQClassRule cqClassRule = new CQClassRule();
    public final Instance authorRule;
    public final Instance publishRule;
    public final DefaultReplicationAgents defaultReplicationAgentsRule;
    protected TestRule ruleChain;

    public CQAuthorPublishClassRule() {
        this(false);
    }

    public CQAuthorPublishClassRule(boolean forceBasicAuth) {
        this.authorRule = ClassRuleUtils.newInstanceRule(forceBasicAuth).withRunMode("author").orDefault(CQClassRule.DEFAULT_AUTHOR_CONFIG);
        this.publishRule = ClassRuleUtils.newInstanceRule(forceBasicAuth).withRunMode("publish").orDefault(CQClassRule.DEFAULT_PUBLISH_CONFIG);
        this.defaultReplicationAgentsRule = new DefaultReplicationAgents(this.authorRule, this.publishRule){

            @Override
            protected boolean configure() {
                String key = "sling.it.configure.default.replication.agents";
                return Boolean.parseBoolean(System.getProperty("sling.it.configure.default.replication.agents", "true"));
            }
        };
        this.ruleChain = RuleChain.outerRule((TestRule)this.cqClassRule).around((TestRule)this.authorRule).around((TestRule)this.publishRule).around((TestRule)this.defaultReplicationAgentsRule);
    }

    public Statement apply(Statement base, Description description) {
        return this.ruleChain.apply(base, description);
    }
}

