/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.client.CQClient;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyPage
extends ExternalResource {
    private static final String SITE_ROOT_PATH = "/content";
    private Logger logger = LoggerFactory.getLogger(EmptyPage.class);
    private final Supplier<SlingClient> clientSupplier;
    private ThreadLocal<String> parentPath = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return EmptyPage.this.initialParentPath();
        }
    };
    private ThreadLocal<String> name = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return EmptyPage.this.initialName();
        }
    };

    public EmptyPage(Supplier<SlingClient> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    protected void before() throws ClientException, InterruptedException {
        this.getClient().createPageWithRetry(this.getName(), this.getTitle(), this.getParentPath(), "", 2000L, 500L, new int[0]);
    }

    protected void after() {
        try {
            this.getClient().deletePageWithRetry(this.getPath(), true, false, 2000L, 500L, new int[0]);
        }
        catch (Exception e) {
            this.logger.error("Unable to delete the page", (Throwable)e);
        }
    }

    protected String initialParentPath() {
        return SITE_ROOT_PATH;
    }

    protected String initialName() {
        return "testpage_" + UUID.randomUUID();
    }

    protected CQClient getClient() throws ClientException {
        try {
            return (CQClient)this.clientSupplier.get().adaptTo(CQClient.class);
        }
        catch (Exception e) {
            throw new ClientException("Cannot create client", (Throwable)e);
        }
    }

    public String getTitle() {
        return "Test Page";
    }

    public String getName() {
        return this.name.get();
    }

    public String getParentPath() {
        return this.parentPath.get();
    }

    public final String getPath() {
        return this.getParentPath() + "/" + this.getName();
    }
}

