/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules.usepackage;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.PackageManagerClient;
import com.adobe.cq.testing.junit.rules.usepackage.UsePackageRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.junit.runners.model.Statement;

public class UsingPackageStatement
extends Statement {
    private Statement base;
    private UsePackageRule rule;

    public UsingPackageStatement(UsePackageRule rule, Statement base) {
        this.base = base;
        this.rule = rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        PackageManagerClient.Package uploadedPackage = null;
        try {
            File packFile = this.generatePackage(this.rule.getSrcPath());
            CQClient adminAuthor = (CQClient)this.rule.getInstance().getAdminClient(CQClient.class);
            PackageManagerClient packClient = (PackageManagerClient)adminAuthor.adaptTo(PackageManagerClient.class);
            uploadedPackage = packClient.uploadPackage(new FileInputStream(packFile), packFile.getName());
            uploadedPackage.install();
            this.base.evaluate();
        }
        finally {
            if (uploadedPackage != null) {
                uploadedPackage.unInstall();
                uploadedPackage.delete();
            }
        }
    }

    private File generatePackage(String resourceFolder) throws IOException, URISyntaxException {
        File generatedPackage = File.createTempFile("temp-package-", ".zip");
        generatedPackage.deleteOnExit();
        this.addResourcesToPackage(resourceFolder, this.initPackage(generatedPackage));
        return generatedPackage;
    }

    private JarOutputStream initPackage(File generatedPackage) throws IOException {
        Manifest man = new Manifest();
        Attributes atts = man.getMainAttributes();
        atts.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        atts.putValue("Build-Jdk", ManagementFactory.getRuntimeMXBean().getVmVersion());
        return new JarOutputStream((OutputStream)new FileOutputStream(generatedPackage), man);
    }

    private void addResourcesToPackage(final String resourceFolder, final JarOutputStream outJar) throws URISyntaxException, IOException {
        URI uri = ((Object)((Object)this)).getClass().getResource(resourceFolder).toURI();
        URL urlRoot = ((Object)((Object)this)).getClass().getResource("/");
        final String rootPath = urlRoot != null ? urlRoot.getPath() : "/";
        try (FileSystem fileSystem = uri.getScheme().equals("jar") ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
            Path myPath = Paths.get(uri);
            Files.walkFileTree(myPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory() && attrs.isRegularFile()) {
                        String rootRelatedPath = file.toString().substring(rootPath.length() - 1);
                        JarEntry je = new JarEntry(rootRelatedPath.substring(resourceFolder.length() + 1));
                        je.setTime(attrs.lastModifiedTime().toMillis());
                        je.setSize(attrs.size());
                        outJar.putNextEntry(je);
                        IOUtils.copy((InputStream)this.getClass().getResourceAsStream(rootRelatedPath.toString()), (OutputStream)outJar);
                        outJar.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        outJar.close();
    }
}

