/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.polling;

import com.adobe.cq.testing.client.WorkflowClient;
import com.adobe.cq.testing.client.workflow.HistoryItem;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInstanceHistoryPoller
extends Polling {
    private Logger LOG = LoggerFactory.getLogger(WorkflowInstanceHistoryPoller.class);
    private String wfInstancePath;
    private WorkflowClient client;
    private String expectedProcess;
    private String expectedStatus;

    public WorkflowInstanceHistoryPoller(WorkflowClient client, String workflowInstancePath) {
        this.wfInstancePath = workflowInstancePath;
        this.client = client;
    }

    public Boolean call() throws ClientException {
        if (this.expectedProcess != null) {
            List<HistoryItem> historyItems = this.client.getWorkflowInstanceHistory(this.wfInstancePath, new int[0]);
            return this.hasState(historyItems);
        }
        this.LOG.warn("No value set for the nodeId to lookup for, will skip");
        return true;
    }

    public void setCondition(String expectedProcess, String expectedStatus) {
        this.expectedProcess = expectedProcess;
        this.expectedStatus = expectedStatus;
    }

    private boolean hasState(List<HistoryItem> historyItems) {
        boolean found = false;
        Iterator<HistoryItem> historyEntryIterator = historyItems.iterator();
        while (!found && historyEntryIterator.hasNext()) {
            HistoryItem historyItem = historyEntryIterator.next();
            String historyProcess = historyItem.getProcess();
            String status = historyItem.getStatus();
            found = historyProcess.equals(this.expectedProcess) && status.equals(this.expectedStatus);
        }
        return found;
    }
}

