/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AbstractSessionServlet;
import com.adobe.cq.social.commons.AsyncReverseReplicator;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import com.day.cq.security.profile.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCreateCommentServlet
extends AbstractSessionServlet {
    public static final AgentFilter REV_AGENT_FILTER = new AgentFilter(){

        public boolean isIncluded(Agent agent) {
            return agent.getConfiguration().isTriggeredOnDistribute();
        }
    };
    public static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    public static final String PROPERTY_ATTACHMENT_TYPE_BLACKLIST = "attachmentTypeBlacklist";
    public static final boolean DEFAULT_REVERSE_REPLICATE = true;
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"jcr:description", "email", "userIdentifier", "url"};
    private static final long serialVersionUID = 1L;
    private static final String TEMPLATE_MASK = "-template\\..*";
    protected static final String TEMPLATE_FORM_ID = ":templatename";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected Externalizer externalizer;
    protected boolean reverseReplicate;
    protected String[] fieldWhitelist;
    protected String[] attachmentTypeBlacklist;
    @Reference
    protected UserManagerFactory userManagerFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    protected AsyncReverseReplicator replicator;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.allowCORS(request, response);
    }

    protected boolean isBot(SlingHttpServletRequest request) {
        String botCheck = request.getParameter("id");
        return botCheck == null || !botCheck.equals("nobot");
    }

    protected ResourceResolver getResourceResolver(Session session) {
        return this.jcrResourceResolverFactory.getResourceResolver(session);
    }

    protected CommentSystem getCommentSystem(Resource r, Session session) {
        Resource res = this.getResourceResolver(session).resolve(r.getPath());
        if (null != res) {
            return (CommentSystem)res.adaptTo(CommentSystem.class);
        }
        return null;
    }

    protected Node getNode(String path, Session session) {
        Resource res = this.getResourceResolver(session).getResource(path);
        if (res != null) {
            return (Node)res.adaptTo(Node.class);
        }
        return null;
    }

    protected void redirect(SlingHttpServletRequest request, SlingHttpServletResponse response, String url) {
        try {
            String cp = request.getContextPath();
            String newURL = url;
            if (!("".equals(cp) || url.contains("://") || url.startsWith(cp))) {
                newURL = cp + url;
            }
            response.sendRedirect(newURL);
        }
        catch (IOException ioe) {
            this.log.error("failed to redirect to {}", (Object)url, (Object)ioe);
        }
    }

    protected void reverseReplicate(String path) {
        this.reverseReplicate(ReplicationActionType.ACTIVATE, path);
    }

    protected void reverseReplicate(ReplicationActionType actionType, String path) {
        if (this.reverseReplicate) {
            this.replicator.reverseReplicate(ReplicationActionType.ACTIVATE, path);
        }
    }

    private List<String> getPaths(Session session, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        Node node = (Node)this.getResourceResolver(session).getResource(path).adaptTo(Node.class);
        paths.add(path);
        try {
            if (node.hasNode("attachments")) {
                Node attNode = node.getNode("attachments");
                NodeIterator iter = attNode.getNodes();
                while (iter.hasNext()) {
                    paths.add(iter.nextNode().getPath());
                }
            }
        }
        catch (PathNotFoundException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        catch (RepositoryException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        return paths;
    }

    protected void setCommentProperties(SlingHttpServletRequest request, Node node) throws RepositoryException {
        Calendar cal = Calendar.getInstance();
        node.setProperty("added", cal);
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        node.setProperty("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        node.setProperty("url", website);
        node.setProperty("ip", request.getRemoteAddr());
        node.setProperty("userAgent", request.getHeader("User-Agent"));
        node.setProperty("referer", request.getHeader("Referer"));
        this.setAuthorizableId(request, node);
        this.log.debug("additional properties set on " + node.getPath());
    }

    private void setAuthorizableId(SlingHttpServletRequest request, Node node) throws RepositoryException {
        String userIdentifier = request.getParameter("userIdentifier");
        Profile sessionProfile = this.getSessionProfile(request);
        String sessionUserId = null;
        if (sessionProfile != null) {
            sessionUserId = sessionProfile.getAuthorizable().getID();
        }
        if (StringUtils.isNotBlank(sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, node.getSession());
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), node.getSession());
                if (userExists && hasPermissions) {
                    JcrUtil.setProperty((Node)node, (String)"authorizableId", (Object)userIdentifier);
                    if (!userIdentifier.equals(sessionUserId)) {
                        this.log.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                    }
                } else {
                    this.log.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(exceptionMessage);
                    }
                    throw new CommentException(exceptionMessage);
                }
                JcrUtil.setProperty((Node)node, (String)"authorizableId", (Object)userId);
            }
        }
    }

    protected void checkAuthorizableId(SlingHttpServletRequest request, Session adminSession) throws RepositoryException {
        String userIdentifier = request.getParameter("userIdentifier");
        Profile sessionProfile = this.getSessionProfile(request);
        String sessionUserId = null;
        if (sessionProfile != null) {
            sessionUserId = sessionProfile.getAuthorizable().getID();
        }
        if (StringUtils.isNotBlank(sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, adminSession);
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), adminSession);
                if (userExists && hasPermissions && !userIdentifier.equals(sessionUserId)) {
                    this.log.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                }
            } else if (!(anonymous || authorMode || userIdentifier == null || sessionUserId.equals(userIdentifier))) {
                StringBuilder exception = new StringBuilder("host ");
                exception.append(request.getRemoteAddr());
                exception.append("posted a comment with suspicious userIdentifier (");
                exception.append(userIdentifier);
                exception.append("), sessionUserId (");
                exception.append(sessionUserId);
                exception.append(")");
                String exceptionMessage = exception.toString();
                if (this.log.isWarnEnabled()) {
                    this.log.warn(exceptionMessage);
                }
                throw new CommentException(exceptionMessage);
            }
        }
    }

    private Profile getSessionProfile(SlingHttpServletRequest request) {
        return (Profile)request.getResourceResolver().adaptTo(Profile.class);
    }

    private Session getRequestSession(SlingHttpServletRequest request) {
        return (Session)request.getResourceResolver().adaptTo(Session.class);
    }

    private boolean userExists(String userId, Session session) {
        try {
            UserManager userManager = this.userManagerFactory.createUserManager(session);
            return userManager.hasAuthorizable(userId);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean hasPermissions(String userIdentifier, Session requestSession, Session adminSession) {
        try {
            Profile profile;
            UserManager um;
            if (StringUtils.isNotBlank((String)userIdentifier) && (um = this.userManagerFactory.createUserManager(adminSession)) != null && (profile = um.get(userIdentifier).getProfile()) != null && requestSession != null) {
                return requestSession.hasPermission(profile.getPath(), "read");
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NoSuchAuthorizableException e) {
            return false;
        }
    }

    private boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected void activate(ComponentContext context) {
        this.reverseReplicate = OsgiUtil.toBoolean(context.getProperties().get(PROPERTY_REVERSE_REPLICATE), (boolean)true);
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.attachmentTypeBlacklist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_ATTACHMENT_TYPE_BLACKLIST));
    }

    protected boolean writeUGCResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String location) throws ServletException, IOException {
        String extension = request.getRequestPathInfo().getExtension();
        boolean ugcResponseWritten = false;
        if (StringUtils.equalsIgnoreCase((String)extension, (String)"html")) {
            response.setHeader("Content-Type", "text/html");
            response.setCharacterEncoding("utf-8");
            TemplateHandlingRequest includeRequest = new TemplateHandlingRequest(request);
            String templateRequested = request.getParameter(TEMPLATE_FORM_ID);
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (null != templateRequested) {
                String locationURL;
                options.setReplaceSelectors(templateRequested);
                Resource newResource = request.getResourceResolver().getResource(resource.getPath());
                includeRequest.getRequestDispatcher(newResource, options).include((ServletRequest)includeRequest, (ServletResponse)response);
                response.setStatus(201);
                String string = locationURL = null != location ? location : resource.getPath();
                if (!this.isCORS(request).booleanValue()) {
                    response.setHeader("Location", locationURL);
                } else {
                    response.setHeader("Location", this.externalizer.absoluteLink(request, request.getScheme(), locationURL));
                }
                ugcResponseWritten = true;
            }
        }
        return ugcResponseWritten;
    }

    protected boolean writeUGCResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws ServletException, IOException {
        return this.writeUGCResponse(request, response, resource, null);
    }

    protected String getResourceSuperType(SlingHttpServletRequest request, String resourceType) {
        String type = ResourceUtil.getResourceSuperType((ResourceResolver)request.getResourceResolver(), (String)resourceType);
        return type;
    }

    private List<String> collectTemplates(Resource resource) {
        ArrayList<String> templates = new ArrayList<String>();
        if (resource == null) {
            return templates;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        if (resource.getResourceSuperType() != null) {
            templates.addAll(this.collectTemplates(resourceResolver.getResource(resource.getResourceSuperType())));
        }
        Iterator childIterator = resource.listChildren();
        while (childIterator.hasNext()) {
            String templateName = ((Resource)childIterator.next()).getName();
            if (!templateName.matches(TEMPLATE_MASK)) continue;
            templates.add(templateName);
        }
        return templates;
    }

    protected Boolean isCORS(SlingHttpServletRequest request) {
        if (null == this.externalizer) {
            return false;
        }
        String localOrigin = this.externalizer.absoluteLink(request, request.getScheme(), "");
        if (!localOrigin.equals(request.getHeader("Origin"))) {
            return true;
        }
        return false;
    }

    protected void allowCORS(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (null == this.externalizer) {
            return;
        }
        String localOrigin = this.externalizer.absoluteLink(request, request.getScheme(), "");
        if (!localOrigin.equals(request.getHeader("Origin"))) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.setHeader("Access-Control-Allow-Headers", "CONTENT-TYPE, LOCATION, *");
            response.setHeader("Access-Control-Expose-Headers", "Content-Type, Location");
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        this.replicator = asyncReverseReplicator;
    }

    protected void unbindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        if (this.replicator == asyncReverseReplicator) {
            this.replicator = null;
        }
    }

    private class TemplateHandlingRequest
    extends SlingHttpServletRequestWrapper {
        public TemplateHandlingRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

