/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSessionServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract void doPost(SlingHttpServletRequest var1, SlingHttpServletResponse var2) throws ServletException, IOException;

    protected void closeAdminSession(Session adminSession) {
        if (adminSession != null && adminSession.isLive()) {
            adminSession.logout();
        }
    }

    protected Session getSessionFromResource(Resource resource) {
        return (Session)resource.getResourceResolver().adaptTo(Session.class);
    }

    protected Session createAdminSession() {
        try {
            return this.repository.loginAdministrative(null);
        }
        catch (RepositoryException e) {
            this.log.error("error creating session: ", (Throwable)e);
            return null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

