/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AttachmentDataSource;
import com.adobe.cq.social.commons.CollabException;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.FileUploadSizeLimit;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollabUtil {
    public static String PN_REMOTE_UGC_LOCATION = "remoteUGC";
    private static final Logger log = LoggerFactory.getLogger(CollabUtil.class);
    public static final String BUCKET_TYPE = "sling:Folder";
    @Deprecated
    public static final String REQ_ATTR_SOCIAL_PROFILE_PAGE = "cq.social.profile.page";
    public static final String GROUP_MEMBERGROUP = "membergroup";
    public static String DEFAULT_AVATAR = "/etc/designs/default/images/social/avatar.png";
    private static SecureRandom randomGenerator = new SecureRandom();
    private static char[] RANDOM_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    private static boolean isUGCPath(Resource resource) {
        return StringUtils.contains((String)resource.getPath(), (String)"/content/usergenerated");
    }

    public static boolean isCommunityGroupResource(Resource resource) {
        Resource contentResource = resource;
        if (CollabUtil.isUGCPath(resource)) {
            String contentPath = StringUtils.substringAfter((String)resource.getPath(), (String)"/content/usergenerated");
            int endPos = StringUtils.lastIndexOf((String)contentPath, (String)"jcr:content");
            if (endPos == -1) {
                return false;
            }
            contentPath = StringUtils.left((String)contentPath, (int)(endPos += "jcr:content".length()));
            contentResource = resource.getResourceResolver().getResource(contentPath);
            if (contentResource == null) {
                return false;
            }
        }
        PageManager pm = (PageManager)contentResource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(contentResource);
        ValueMap properties = null;
        String groupProp = null;
        if (page != null) {
            properties = page.getProperties();
            groupProp = (String)properties.get(GROUP_MEMBERGROUP, null);
            while (groupProp == null && (page = page.getParent()) != null) {
                properties = page.getProperties();
                groupProp = (String)properties.get(GROUP_MEMBERGROUP, null);
            }
        }
        return groupProp != null;
    }

    public static boolean hasModeratePermissions(Resource resource) {
        Session session = (Session)resource.getResourceResolver().adaptTo(Session.class);
        try {
            String ACTION_ALL = "read,add_node,remove,set_property";
            return session.hasPermission(resource.getPath(), ACTION_ALL);
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    public static boolean isResourceOwner(Resource resource) {
        Session session = (Session)resource.getResourceResolver().adaptTo(Session.class);
        ValueMap map = (ValueMap)resource.adaptTo(ValueMap.class);
        String resourceAuthorID = (String)map.get("userIdentifier", String.class);
        String authorID = (String)map.get("jcr:createdBy", String.class);
        if (StringUtils.isEmpty((String)resourceAuthorID)) {
            resourceAuthorID = (String)map.get("jcr:lastModifiedBy", String.class);
        }
        return StringUtils.equals((String)session.getUserID(), (String)resourceAuthorID) || StringUtils.equals((String)session.getUserID(), (String)authorID);
    }

    public static String resourceToUGCPath(Resource resource) {
        StringBuilder path = new StringBuilder("/content/usergenerated");
        path.append(CollabUtil.getPagePath(resource));
        path.append("/").append("jcr:content");
        path.append("/").append(CollabUtil.getIdFromResource(resource));
        return path.toString();
    }

    public static String UGCToResourcePath(Resource resource) {
        return CollabUtil.UGCToResourcePath(resource.getPath(), resource.getResourceResolver());
    }

    public static String UGCToResourcePath(String ugcPath, ResourceResolver resolver) {
        String pagePath = StringUtils.substringAfter((String)ugcPath, (String)"/content/usergenerated");
        return resolver.map(pagePath);
    }

    public static String getPagePath(Resource resource) {
        return CollabUtil.getPagePath(resource.getPath());
    }

    public static String getPagePath(String path) {
        return StringUtils.substringBefore((String)path, (String)"/jcr:content");
    }

    public static String getIdFromResource(Resource resource) {
        return StringUtils.substringBefore((String)ResourceUtil.getName((Resource)resource), (String)".");
    }

    public static boolean canAddNode(Session session, String path) {
        try {
            StringBuilder childPath = new StringBuilder(path).append("/foo_").append(new Date().getTime());
            return session != null && session.hasPermission(childPath.toString(), "add_node");
        }
        catch (RepositoryException e) {
            log.error("canAddNode: error while checking add node permission on[{}]", (Object)path, (Object)e);
            return false;
        }
    }

    @Deprecated
    public static String getAvatar(Profile profile) {
        return CollabUtil.getAvatar(profile, null, null);
    }

    public static String getAvatar(UserProperties userProperties) {
        return CollabUtil.getAvatar(userProperties, null, null);
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar) {
        return CollabUtil.getAvatar(userProperties, email, absoluteDefaultAvatar, AVATAR_SIZE.THIRTY_TWO);
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        String avatar = DEFAULT_AVATAR;
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail.32.png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("getAvatar: error getting avatar: ", (Throwable)e);
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    @Deprecated
    public static String getAvatar(Profile profile, String email, String absoluteDefaultAvatar) {
        String avatar = DEFAULT_AVATAR;
        if (profile != null) {
            String avatarPath = profile.getAvatarURL(".prof.thumbnail.32.png", null);
            if (avatarPath != null) {
                avatar = avatarPath;
            } else {
                String gravatar;
                String primaryMail = profile.getPrimaryMail();
                if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                    avatar = gravatar;
                }
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    @Deprecated
    public static String getAvatar(Profile profile, String email, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        String avatar = DEFAULT_AVATAR;
        if (profile != null) {
            String avatarPath = profile.getAvatarURL(".prof.thumbnail." + size.size + ".png", null);
            if (avatarPath != null) {
                avatar = avatarPath;
            } else {
                String gravatar;
                String primaryMail = profile.getPrimaryMail();
                if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                    avatar = gravatar;
                }
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    public static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)absoluteDefaultAvatar)) {
            return null;
        }
        try {
            email = Text.md5((String)email, (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://www.gravatar.com/avatar/");
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static String generateRandomString(int length) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            str.append(RANDOM_CHARS[randomGenerator.nextInt(RANDOM_CHARS.length)]);
        }
        return str.toString();
    }

    public static String prepareUserGeneratedContent(ResourceResolver resolver, String path) throws CollabException {
        String ugcPagePath = path.startsWith("/content/usergenerated") ? "" : "/content/usergenerated";
        StringTokenizer pathElems = new StringTokenizer(path, "/");
        while (pathElems.hasMoreTokens()) {
            if (resolver.getResource(ugcPagePath = ugcPagePath + "/" + pathElems.nextToken()) != null) continue;
            if (ugcPagePath.equals("/content/usergenerated/content")) {
                try {
                    CollabUtil.createNode(resolver, ugcPagePath, BUCKET_TYPE);
                    CollabUtil.save(resolver);
                    continue;
                }
                catch (CollabException ce) {
                    throw new CommentException("failed to prepare user generated content", (Throwable)((Object)ce));
                }
            }
            try {
                CollabUtil.createPage(resolver, ugcPagePath, null, null, null, null);
            }
            catch (CollabException ce) {
                throw new CommentException("failed to prepare user generated content", (Throwable)((Object)ce));
            }
        }
        return ugcPagePath;
    }

    public static void save(ResourceResolver resolver) throws CollabException, IllegalArgumentException {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        try {
            session.save();
        }
        catch (RepositoryException re) {
            throw new CollabException("failed to save changes", re);
        }
    }

    public static Page createPage(ResourceResolver resolver, String path, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        String name = Text.getName((String)path);
        return CollabUtil.createPage(resolver, parentPath, name, template, resourceTypeProp, resourceType, title);
    }

    public static Page createPage(ResourceResolver resolver, String parentPath, String name, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        Object e;
        try {
            if (resolver.getResource(parentPath) == null) {
                CollabUtil.createNode(resolver, parentPath, "nt:unstructured");
                CollabUtil.save(resolver);
            }
            if (!JcrUtil.isValidName((String)name)) {
                name = JcrUtil.createValidName((String)name, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING);
            }
            Page page = ((PageManager)resolver.adaptTo(PageManager.class)).create(parentPath, name, template, title);
            if (StringUtils.isNotEmpty((String)resourceTypeProp)) {
                ((Node)page.getContentResource().adaptTo(Node.class)).setProperty(resourceTypeProp, resourceType);
            }
            return page;
        }
        catch (RepositoryException re) {
            e = re;
        }
        catch (WCMException wcme) {
            e = wcme;
        }
        catch (CollabException ce) {
            e = ce;
        }
        throw new CollabException("failed to create page", (Throwable)e);
    }

    public static Node createNode(ResourceResolver resolver, String path, String nodeType) throws CollabException {
        try {
            return CollabUtil.createNode((Session)resolver.adaptTo(Session.class), path, nodeType);
        }
        catch (Exception e) {
            throw new CollabException("failed to create node", e);
        }
    }

    public static Node createNode(Session session, String path, String nodeType) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            Node root = session.getRootNode();
            StringTokenizer names = new StringTokenizer(Text.getRelativeParent((String)path, (int)1), "/");
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                if (!root.hasNode(name)) {
                    root.addNode(name);
                }
                root = root.getNode(name);
            }
            return root.addNode(Text.getName((String)path), nodeType);
        }
        catch (RepositoryException e) {
            throw new CommentException("Failed to create node", e);
        }
    }

    @Deprecated
    public static Profile getProfile(ResourceResolver resolver, ProfileManager pm, String userId) {
        Profile profile = null;
        if (null != pm && null != userId) {
            try {
                Session session = (Session)resolver.adaptTo(Session.class);
                profile = pm.getProfile(userId, session);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return profile;
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return userProperties;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        Throwable cause = e;
        do {
            if (!(cause instanceof InvalidItemStateException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    @Deprecated
    public static boolean mayEdit(ResourceResolver resolver, String authorizableID, Comment comment) {
        return CollabUtil.canAddNode((Session)resolver.adaptTo(Session.class), "/content/usergenerated") && comment.getAuthor().getId().equals(authorizableID);
    }

    public static String formatFileSize(long size) {
        String[] units = new String[]{" bytes", " KB", " MB", " GB", " TB"};
        int u = 0;
        long mod = 0L;
        while (size > 1000L) {
            mod = size % 1000L;
            size /= 1000L;
            ++u;
        }
        long frac = mod / 100L;
        if (frac == 0L) {
            return size + units[u];
        }
        return size + "." + frac + units[u];
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, long attachmentSizeLimit, List<String> whitelist, String[] blacklist) {
        return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, new FileUploadSizeLimit(attachmentSizeLimit, attachmentSizeLimit), whitelist, blacklist);
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, FileUploadSizeLimit fileUploadSizeLimit, List<String> whitelist, String[] blacklist) {
        ArrayList<AttachmentDataSource> attachments = null;
        if (fileRequestParameters != null && fileRequestParameters.length > 0 && !fileRequestParameters[0].isFormField()) {
            attachments = new ArrayList<AttachmentDataSource>();
            for (RequestParameter fileRequestParameter : fileRequestParameters) {
                if (fileUploadSizeLimit.fits(fileRequestParameter)) {
                    AttachmentDataSource attachmentDataSource = new AttachmentDataSource(fileRequestParameter);
                    String contentFileType = attachmentDataSource.getTypeFromFileName();
                    String contentType = attachmentDataSource.getType();
                    if (StringUtils.isNotBlank((String)contentFileType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentFileType)) {
                        if (whitelist != null && !whitelist.isEmpty()) {
                            if (StringUtils.isNotBlank((String)contentType) && whitelist.contains(contentType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentType)) {
                                attachments.add(attachmentDataSource);
                                continue;
                            }
                            if (StringUtils.isNotBlank((String)contentType)) {
                                log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the" + " servlets attachment black list");
                                continue;
                            }
                            log.info("Tika couldnt figure out the file type. Not attaching it as it is suspicious");
                            continue;
                        }
                        if (StringUtils.isNotBlank((String)contentType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentType)) {
                            attachments.add(attachmentDataSource);
                            continue;
                        }
                        if (StringUtils.isNotBlank((String)contentType)) {
                            log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the" + " servlets attachment black list");
                            continue;
                        }
                        log.info("Tika couldnt figure out the file type. Not attaching it as it is suspicious");
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)contentFileType)) {
                        log.info("File of type " + contentFileType + "with name " + attachmentDataSource.getName() + " is blacklisted for security reasons. To upload edit the" + " servlets attachment black list");
                        continue;
                    }
                    log.info("File Doesnt have a valid extension. Not attaching it as it is suspicious");
                    continue;
                }
                log.info("File bigger than specified size, so ignoring the attachment");
            }
        }
        return attachments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AVATAR_SIZE {
        THIRTY_TWO(32),
        FOURTY_EIGHT(48);

        private final int size;

        private AVATAR_SIZE(int s) {
            this.size = s;
        }
    }
}

