/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentUtil {
    public static boolean isPending(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && CommentUtil.isSystemModerated(component) && "".equals(CommentUtil.getProperty(resource, "approved", ""));
    }

    public static boolean isApproved(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && (!CommentUtil.isSystemModerated(component) || CommentUtil.getProperty(resource, "approved", false) != false);
    }

    public static boolean isSpam(Resource resource) {
        return CommentUtil.getProperty(resource, "isSpam", false);
    }

    public static boolean isSystemModerated(Resource component) {
        return CommentUtil.getProperty(component, "moderateComments", false);
    }

    public static boolean isSystemClosed(Resource component) {
        return CommentUtil.getProperty(component, "closed", false);
    }

    public static <T> T getProperty(Resource resource, String name, T defaultValue) {
        try {
            return (T)((ValueMap)resource.adaptTo(ValueMap.class)).get(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

