/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AttachmentDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.request.RequestParameter;

public class FileUploadSizeLimit {
    private final long attachmentSizeLimit;
    private final long imageSizeLimit;
    private static final String[] imagesContentType = new String[]{".png", ".jpg", ".jpeg", ".gif"};

    public FileUploadSizeLimit(long attachmentSizeLimit, long imageSizeLimit) {
        this.attachmentSizeLimit = attachmentSizeLimit;
        this.imageSizeLimit = imageSizeLimit;
    }

    public boolean fits(RequestParameter fileRequestParameter) {
        AttachmentDataSource attachmentDataSource = new AttachmentDataSource(fileRequestParameter);
        String contentType = attachmentDataSource.getType();
        if (ArrayUtils.contains((Object[])imagesContentType, (Object)contentType)) {
            return fileRequestParameter.getSize() <= this.imageSizeLimit;
        }
        return fileRequestParameter.getSize() <= this.attachmentSizeLimit;
    }
}

