/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.EmailConfig;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.Externalizer;
import com.day.cq.mailer.MailService;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.mail.Header;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={WorkflowProcess.class, EmailConfig.class})
@org.apache.felix.scr.annotations.Property(name="process.label", value={"Send Email"})
public class SendEmailProcess
implements WorkflowProcess,
EmailConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SendEmailProcess.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    protected MailService mailService;
    @Reference
    protected UserManagerFactory userManagerFactory;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private static final String DEFAULT_CHARSET = "utf-8";
    private Map<String, Map<String, String>> configValueMap;
    private Map<String, Map<String, String>> configPathMap;
    private Map<String, Long> lastConfigUpdateCheck;
    @org.apache.felix.scr.annotations.Property(value={"300000"})
    private static final String CHECK_UPDATE_INTERVAL = "checkUpdate.interval";
    private long checkUpdateInterval = 300000L;

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        Object prop = props.get(CHECK_UPDATE_INTERVAL);
        if (prop != null) {
            this.checkUpdateInterval = Long.valueOf(prop.toString().trim());
        }
        this.configValueMap = new HashMap<String, Map<String, String>>();
        this.configPathMap = new HashMap<String, Map<String, String>>();
        this.lastConfigUpdateCheck = new HashMap<String, Long>();
    }

    public void execute(WorkItem item, WorkflowSession wfSession, MetaDataMap metaData) throws WorkflowException {
        ResourceResolver resolver;
        try {
            resolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", wfSession.getSession()));
        }
        catch (LoginException e) {
            throw new WorkflowException("could not get resource resolver", (Throwable)e);
        }
        if (null == this.mailService) {
            throw new WorkflowException("cannot send email, mail service unavailable.");
        }
        try {
            String[] args = this.buildArguments(metaData);
            String template = null;
            String configType = null;
            String charset = DEFAULT_CHARSET;
            if (args.length > 0 && args[0].length() > 0) {
                charset = this.getCharSet(wfSession.getSession(), args[0]);
                template = this.loadTemplate(wfSession.getSession(), args[0], charset);
                if (args.length > 1 && args[1].length() > 0) {
                    configType = args[1];
                }
            } else if (args.length > 1 && args[1].length() > 0) {
                template = args[1];
            }
            if (template != null) {
                LOG.debug("Loaded template: {}", template);
                UserManager userManager = this.userManagerFactory.createUserManager(wfSession.getSession());
                StrSubstitutor substitutor = new StrSubstitutor((StrLookup)new PayloadLookup(item, wfSession, userManager, configType, resolver));
                Email email = this.createEmail(template, charset, substitutor);
                if (email.getToAddresses().size() > 0) {
                    this.mailService.sendEmail(email);
                    LOG.info("Email sent based on {}", (Object)template);
                } else {
                    LOG.warn("did not send email, no recipient addresses available.");
                }
            } else {
                LOG.warn("Cannot send mail. No email template defined");
            }
        }
        catch (EmailException e) {
            LOG.warn("cannot send email: ", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get("PROCESS_ARGS", String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> args = new ArrayList<String>();
        String templatePath = (String)metaData.get("templatePath", String.class);
        String template = (String)metaData.get("template", String.class);
        if (templatePath != null && !templatePath.equals("")) {
            args.add(templatePath);
        } else if (template != null && !template.equals("")) {
            args.add("");
            args.add(template);
        }
        return args.toArray(new String[args.size()]);
    }

    private Email createEmail(String template, String charSet, StrSubstitutor substitutor) throws Exception {
        String[] bounceAddress;
        InternetAddress af;
        CountingInputStream in = new CountingInputStream((InputStream)new ByteArrayInputStream(template.getBytes(charSet)));
        InternetHeaders iHdrs = new InternetHeaders((InputStream)in);
        HashMap<String, String[]> hdrs = new HashMap<String, String[]>();
        Enumeration e = iHdrs.getAllHeaders();
        while (e.hasMoreElements()) {
            Header hdr = (Header)e.nextElement();
            String name = hdr.getName().toLowerCase();
            LOG.debug("Header: {} = {}", (Object)name, (Object)hdr.getValue());
            hdrs.put(name, iHdrs.getHeader(name));
        }
        String templateBody = template.substring(in.getCount());
        SimpleEmail email = new SimpleEmail();
        email.setCharset(charSet);
        StringBuilder rcpts = new StringBuilder();
        for (String to : SendEmailProcess.saveRemoveHeader(hdrs, "to")) {
            to = substitutor.replace(to);
            af = new InternetAddress(to);
            email.addTo(af.getAddress(), af.getPersonal());
            rcpts.append(to).append(", ");
        }
        for (String cc : SendEmailProcess.saveRemoveHeader(hdrs, "cc")) {
            cc = substitutor.replace(cc);
            af = new InternetAddress(cc);
            email.addCc(af.getAddress(), af.getPersonal());
            rcpts.append(cc).append(", ");
        }
        for (String bcc : SendEmailProcess.saveRemoveHeader(hdrs, "bcc")) {
            bcc = substitutor.replace(bcc);
            af = new InternetAddress(bcc);
            email.addBcc(af.getAddress(), af.getPersonal());
            rcpts.append(bcc).append(", ");
        }
        for (String replyTo : SendEmailProcess.saveRemoveHeader(hdrs, "Reply-To")) {
            replyTo = substitutor.replace(replyTo);
            af = new InternetAddress(replyTo);
            email.addReplyTo(af.getAddress(), af.getPersonal());
            rcpts.append(replyTo).append(", ");
        }
        for (String from : SendEmailProcess.saveRemoveHeader(hdrs, "from")) {
            from = substitutor.replace(from);
            af = new InternetAddress(from);
            email.setFrom(af.getAddress(), af.getPersonal());
        }
        String[] subject = SendEmailProcess.saveRemoveHeader(hdrs, "subject");
        if (subject.length > 0) {
            email.setSubject(substitutor.replace(subject[0]));
        }
        if ((bounceAddress = SendEmailProcess.saveRemoveHeader(hdrs, "bounce-to")).length > 0) {
            email.setBounceAddress(substitutor.replace(bounceAddress[0]));
        }
        for (String name : hdrs.keySet()) {
            for (String value : (String[])hdrs.get(name)) {
                value = substitutor.replace(value);
                email.addHeader(name, value);
            }
        }
        templateBody = substitutor.replace(templateBody);
        LOG.debug("Substituted mail body: {}", (Object)templateBody);
        email.setMsg(templateBody);
        LOG.info("Recipients {}", (Object)rcpts);
        return email;
    }

    private static String[] saveRemoveHeader(Map<String, String[]> hdrs, String name) {
        String[] ret = hdrs.remove(name);
        return ret == null ? new String[]{} : ret;
    }

    private String getCharSet(Session session, String path) {
        String encoding = DEFAULT_CHARSET;
        try {
            Node content = session.getNode(path + "/" + "jcr:content");
            encoding = content.hasProperty("jcr:encoding") ? content.getProperty("jcr:encoding").getString() : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadTemplate(Session session, String path, String charSet) {
        InputStream is = null;
        try {
            Node content = session.getNode(path + "/" + "jcr:content");
            is = content.getProperty("jcr:data").getBinary().getStream();
            InputStreamReader r = new InputStreamReader(is, charSet);
            StringWriter w = new StringWriter();
            IOUtils.copy((Reader)r, (Writer)w);
            String string = w.toString();
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        catch (Exception e) {
            LOG.error("Error while loading mail template {}:{}", (Object)path, (Object)e.toString());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    private String getProperty(ResourceResolver resolver, String configPath, String propertyName) throws RepositoryException, IOException {
        Node configNode;
        Resource config = resolver.getResource(configPath);
        if (config != null && (configNode = (Node)config.adaptTo(Node.class)) != null) {
            if (configNode.getProperty("jcr:primaryType").getString().equals("nt:file")) {
                Property configProp = configNode.getNode("jcr:content").getProperty("jcr:data");
                if (configProp != null) {
                    Properties props = new Properties();
                    props.load(configProp.getBinary().getStream());
                    String val = props.getProperty(propertyName);
                    String string = val = val == null || !val.startsWith("\"") || !val.endsWith("\"") ? val : val.substring(1, val.length() - 1);
                    if (val != null && val.length() > 0) {
                        return val;
                    }
                }
            } else if (configNode.getProperty("jcr:primaryType").getString().equals("sling:OsgiConfig") && configNode.hasProperty(propertyName)) {
                return configNode.getProperty(propertyName).getString();
            }
        }
        if (propertyName.equals("host.prefix")) {
            Externalizer externalizer = (Externalizer)resolver.adaptTo(Externalizer.class);
            String externalizerHost = externalizer.externalLink(resolver, "local", "");
            if (externalizerHost != null && externalizerHost.endsWith("/")) {
                return externalizerHost.substring(0, externalizerHost.length() - 1);
            }
            return externalizerHost;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig(String configType) {
        ResourceResolver resolver = null;
        Map<String, String> configPaths = this.configPathMap.get(configType);
        Map<String, String> configValues = this.configValueMap.get(configType);
        if (configPaths == null || configValues == null) {
            return;
        }
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            for (String configName : configPaths.keySet()) {
                String configValue = this.getProperty(resolver, configPaths.get(configName), configName);
                if (configValue == null) continue;
                configValues.put(configName, configValue);
            }
            this.lastConfigUpdateCheck.put(configType, System.currentTimeMillis());
        }
        catch (LoginException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigUpdate(String configType) {
        long lastUpdate;
        if (this.resourceResolverFactory == null) {
            LOG.error("Can't read forum email configuration with null ResourceResolverFactory.");
            return;
        }
        long l = lastUpdate = this.lastConfigUpdateCheck.containsKey(configType) ? this.lastConfigUpdateCheck.get(configType) : 0L;
        if (System.currentTimeMillis() - lastUpdate < this.checkUpdateInterval) {
            return;
        }
        SendEmailProcess sendEmailProcess = this;
        synchronized (sendEmailProcess) {
            long l2 = lastUpdate = this.lastConfigUpdateCheck.containsKey(configType) ? this.lastConfigUpdateCheck.get(configType) : 0L;
            if (System.currentTimeMillis() - lastUpdate < this.checkUpdateInterval) {
                return;
            }
            this.readConfig(configType);
        }
    }

    @Override
    public String getConfig(String configType, String name) {
        this.checkConfigUpdate(configType);
        Map<String, String> configValues = this.configValueMap.get(configType);
        return configValues == null ? null : configValues.get(name);
    }

    @Override
    public void setConfig(String configType, String name, String configPath, String defaultValue) {
        if (!this.configPathMap.containsKey(configType)) {
            this.configPathMap.put(configType, new HashMap());
        }
        Map<String, String> configPaths = this.configPathMap.get(configType);
        configPaths.put(name, configPath);
        if (!this.configValueMap.containsKey(configType)) {
            this.configValueMap.put(configType, new HashMap());
        }
        Map<String, String> configValues = this.configValueMap.get(configType);
        configValues.put(name, defaultValue);
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    private class PayloadLookup
    extends StrLookup {
        private final ValueMap properties = new ValueMapDecorator(new HashMap());
        private Node content = null;

        private PayloadLookup(WorkItem workItem, WorkflowSession session, UserManager userManager, String configType, ResourceResolver resolver) throws RepositoryException {
            this.put("item.id", workItem.getId());
            this.put("item.node.id", workItem.getNode().getId());
            this.put("item.node.title", workItem.getNode().getTitle());
            this.put("item.node.type", workItem.getNode().getType());
            this.putAll(workItem.getNode().getMetaDataMap(), "item.node.data.");
            Workflow workflow = workItem.getWorkflow();
            this.put("instance.id", workflow.getId());
            this.put("instance.state", workflow.getState());
            this.putAll(workflow.getMetaDataMap(), "instance.data.");
            this.put("model.title", workflow.getWorkflowModel().getTitle());
            this.put("model.description", workflow.getWorkflowModel().getDescription());
            this.put("model.id", workflow.getWorkflowModel().getId());
            this.put("model.version", workflow.getWorkflowModel().getVersion());
            this.putAll(workflow.getWorkflowModel().getMetaDataMap(), "model.data.");
            if (SendEmailProcess.this.configValueMap.containsKey(configType)) {
                SendEmailProcess.this.checkConfigUpdate(configType);
                this.properties.putAll((Map)SendEmailProcess.this.configValueMap.get(configType));
            }
            String userPath = (String)workItem.getWorkflow().getMetaDataMap().get("socialstateToggleUser", (Object)"");
            UserPropertiesManager upMgr = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
            UserProperties initiator = null;
            if (StringUtils.isBlank((String)userPath)) {
                String initiatorId = workflow.getInitiator();
                initiator = upMgr.getUserProperties(initiatorId, "profile");
            } else {
                int lastBackSlashIndex = userPath.lastIndexOf(47);
                if (lastBackSlashIndex != -1) {
                    initiator = upMgr.getUserProperties(userPath.substring(lastBackSlashIndex + 1), "profile");
                }
            }
            if (initiator == null) {
                throw new NullPointerException("Null initiator with userPath=" + userPath + " and initiatorId=" + workflow.getInitiator());
            }
            this.putAll(initiator, "initiator.");
            WorkflowData workflowData = workflow.getWorkflowData();
            this.putAll(workflowData.getMetaDataMap(), "data.");
            if ("JCR_PATH".equals(workflowData.getPayloadType())) {
                String path = workflowData.getPayload().toString();
                this.put("payload.path", path);
                try {
                    this.content = session.getSession().getNode(path);
                }
                catch (RepositoryException e) {
                    LOG.error("Payload content not accessible: {}", (Object)e.toString());
                }
            } else {
                this.put("payload.data", workflowData.getPayload());
                this.put("payload.type", workflowData.getPayloadType());
            }
            StringBuilder props = new StringBuilder();
            TreeSet names = new TreeSet(this.properties.keySet());
            for (String name : names) {
                Object value = this.properties.get((Object)name);
                LOG.debug("- {}:{}", (Object)name, value);
                props.append(name).append(":").append(value).append("\n");
            }
            this.put("properties", props.toString());
        }

        public String lookup(String key) {
            if (key.startsWith("payload.") && !key.equals("payload.path")) {
                String path = key.substring(8).replace('.', '/');
                try {
                    if (this.content.hasProperty(path)) {
                        Property p = this.content.getProperty(path);
                        if (p.getType() == 2) {
                            return "[binary, " + p.getLength() + " bytes]";
                        }
                        return p.getString();
                    }
                }
                catch (RepositoryException e) {
                    LOG.error("error while retrieving property for key {}: {}", (Object)key, (Object)e.toString());
                }
            }
            return (String)this.properties.get(key, String.class);
        }

        private void put(String name, Object value) {
            if (value != null) {
                this.properties.put((Object)name, value);
            }
        }

        private void putAll(MetaDataMap metaData, String prefix) {
            for (String name : metaData.keySet()) {
                if (name.endsWith("template")) {
                    String value = (String)metaData.get(name, String.class);
                    if (value == null) continue;
                    value = this.escapeVariables(value);
                    this.properties.put((Object)(prefix + name), (Object)value);
                    continue;
                }
                this.properties.put((Object)(prefix + name), metaData.get(name, String.class));
            }
        }

        private String escapeVariables(String value) {
            return value == null ? value : value.replaceAll("\\$\\{([\\w.:_\\/]+)\\}", "\\$\\$\\{$1\\}");
        }

        private void putAll(UserProperties auth, String prefix) throws RepositoryException {
            String[] propNames = auth.getPropertyNames();
            for (int i = 0; i < propNames.length; ++i) {
                String name = propNames[i];
                this.properties.put((Object)(prefix + name), (Object)auth.getProperty(name));
            }
            this.properties.put((Object)(prefix + "id"), (Object)auth.getAuthorizableID());
            String name = auth.getProperty("givenName");
            if (name == null) {
                name = auth.getProperty("familyName");
            }
            this.properties.put((Object)(prefix + "name"), (Object)name);
        }
    }
}

