/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.digest.impl;

import com.adobe.cq.social.commons.digest.DigestContext;
import com.adobe.cq.social.commons.digest.DigestEventType;
import com.adobe.cq.social.commons.digest.DigestService;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class AbstractDigestTask
implements Runnable {
    private static final int DEFAULT_DIGEST_MAX_SIZE = 50;
    @Property(intValue={50})
    private static final String DIGEST_MAX_SIZE_PROPERTY = "digest.maximumSize";
    private int maximumSize = 50;
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private SlingRepository slingRepository;
    private BundleContext bundleContext;
    @Reference
    private DiscoveryService discoveryService;

    protected abstract DigestEventType getDigestEventType();

    public void run() {
        TopologyView view = this.discoveryService.getTopology();
        InstanceDescription currentInstance = view.getLocalInstance();
        if (currentInstance != null && currentInstance.isLeader()) {
            try {
                DigestContext digestContext = new DigestContext(this.getDigestEventType(), this.maximumSize);
                ServiceReference[] refs = this.bundleContext.getServiceReferences(DigestService.class.getName(), null);
                if (refs != null) {
                    for (ServiceReference ref : refs) {
                        DigestService digestService = (DigestService)this.bundleContext.getService(ref);
                        digestService.generateDigest(digestContext);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                this.log.error("could not look up digest services: {}", (Throwable)e);
            }
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.log.info("Activating {}.", (Object)this.getClass().getName());
        this.bundleContext = context.getBundleContext();
        this.configure(context);
    }

    private void configure(ComponentContext context) {
        Object prop;
        Dictionary props = context.getProperties();
        if (this.log.isDebugEnabled()) {
            Enumeration propKeys = props.keys();
            while (propKeys.hasMoreElements()) {
                String nextKey = (String)propKeys.nextElement();
                Object nextProp = props.get(nextKey);
                String clazz = nextProp != null ? " Instance of " + nextProp.getClass().getName() + "." : "";
                this.log.debug("SCR prop {} = {}." + clazz, (Object)nextKey, nextProp);
            }
        }
        if ((prop = props.get(DIGEST_MAX_SIZE_PROPERTY)) != null) {
            this.maximumSize = OsgiUtil.toInteger(prop, (int)50);
            if (this.maximumSize < 0) {
                this.maximumSize = 50;
            }
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    protected void unbindDiscoveryService(DiscoveryService discoveryService) {
        if (this.discoveryService == discoveryService) {
            this.discoveryService = null;
        }
    }
}

