/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply.impl;

import com.adobe.cq.social.commons.emailreply.EmailClientProvider;
import com.adobe.cq.social.commons.emailreply.EmailQuotedTextPatterns;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
@Service
public abstract class AbstractEmailClientProvider
implements EmailClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailClientProvider.class);
    private Integer priorityOrder;
    @Property(value={}, cardinality=0x7FFFFFFF)
    protected static final String REPLY_EMAIL_PATTERNS = "replyEmailPatterns";
    protected static final int DEFAULT_PRIORITY_ORDER = 1;
    @Property(intValue={1})
    protected static final String PRIORITY_ORDER = "priorityOrder";
    protected List<Pattern> patterns = new ArrayList<Pattern>();
    @Reference
    protected EmailQuotedTextPatterns emailQuotedTextPatterns;

    protected void configure(ComponentContext context) {
        Dictionary props = context.getProperties();
        Object prop = props.get(PRIORITY_ORDER);
        if (prop != null) {
            this.priorityOrder = OsgiUtil.toInteger(prop, (int)1);
            if (this.priorityOrder < 0) {
                LOGGER.error("Priority order cannot be negative");
            }
        }
        if ((prop = props.get(REPLY_EMAIL_PATTERNS)) != null) {
            String[] regexArr;
            this.patterns = new ArrayList<Pattern>();
            for (String regex : regexArr = OsgiUtil.toStringArray(prop)) {
                if (!StringUtils.isNotEmpty((String)regex)) continue;
                this.patterns.add(Pattern.compile(this.emailQuotedTextPatterns.decomposePattern(regex)));
            }
        }
    }

    public boolean acceptsMail(MimeMessage mailMessage) {
        if (mailMessage != null) {
            try {
                String originalMsg = this.getEmailContent(mailMessage);
                LOGGER.debug("Received Mail {}.", (Object)originalMsg);
                for (Pattern pattern : this.patterns) {
                    Matcher m = pattern.matcher(originalMsg);
                    if (!m.find()) continue;
                    LOGGER.debug("Is accepted : true");
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while reading mail content", (Throwable)e);
            }
            catch (MessagingException e) {
                LOGGER.error("Error while reading mail content", (Throwable)e);
            }
        }
        return false;
    }

    protected String getMessage(MimeMessage mailMessage) throws IOException, MessagingException {
        String originalMessage = this.getEmailContent(mailMessage);
        LOGGER.debug("Received Mail {}.", (Object)originalMessage);
        for (Pattern pattern : this.patterns) {
            Matcher m = pattern.matcher(originalMessage);
            if (!m.find()) continue;
            LOGGER.debug("Removing quoted text using pattern : {}", (Object)pattern.toString());
            return originalMessage.substring(0, m.start()).trim();
        }
        return "";
    }

    public Properties getMailProperties(MimeMessage mailMessage) {
        Properties mailProperties = new Properties();
        try {
            if (mailMessage != null) {
                mailProperties.setProperty("email.message", this.postProcess(this.getMessage(mailMessage)));
                mailProperties.setProperty("email.author.id", this.getAuthor(mailMessage));
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to get email properties : ", (Throwable)e);
        }
        catch (MessagingException e) {
            LOGGER.warn("failed to get email properties : ", (Throwable)e);
        }
        return mailProperties;
    }

    public String getEmailContent(MimeMessage mailMessage) throws IOException, MessagingException {
        String message = "";
        if (mailMessage.getContent() != null) {
            Object mailContent = mailMessage.getContent();
            if (mailContent instanceof String) {
                message = mailContent.toString();
            } else if (mailContent instanceof Multipart) {
                message = AbstractEmailClientProvider.getPostFromMultiPartMail((Multipart)mailContent);
            }
        }
        return message;
    }

    private static String getPostFromMultiPartMail(Multipart multipartMail) throws MessagingException, IOException {
        if (multipartMail != null) {
            for (int i = 0; i < multipartMail.getCount(); ++i) {
                BodyPart part = multipartMail.getBodyPart(i);
                String text = AbstractEmailClientProvider.getText(part);
                if (text == null) continue;
                return text;
            }
        }
        return "";
    }

    private static String getText(BodyPart part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain")) {
            return (String)part.getContent();
        }
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                String text = AbstractEmailClientProvider.getText(bp);
                if (text == null) continue;
                return text;
            }
        }
        return null;
    }

    private String getAuthor(MimeMessage mailMessage) throws MessagingException {
        String author = "";
        Address[] fromAddresses = mailMessage.getFrom();
        if (fromAddresses != null && fromAddresses.length > 0) {
            Address authorAddress = fromAddresses[0];
            if (authorAddress instanceof InternetAddress) {
                author = ((InternetAddress)authorAddress).getAddress();
            } else {
                author = authorAddress.toString();
                int startingIndex = author.indexOf("<");
                int endingIndex = author.indexOf(">");
                if (startingIndex != -1 && endingIndex != -1) {
                    author = author.substring(startingIndex + 1, endingIndex).trim();
                }
            }
        }
        LOGGER.debug("Mail author found: {}", (Object)author);
        return author;
    }

    private String postProcess(String message) {
        String processedMsg = message.replaceAll("[\\s|\n|\r\n]+$", "").replaceAll("(------*)|(______*)$", "");
        processedMsg = processedMsg.replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
        return processedMsg;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    protected void bindEmailQuotedTextPatterns(EmailQuotedTextPatterns emailQuotedTextPatterns) {
        this.emailQuotedTextPatterns = emailQuotedTextPatterns;
    }

    protected void unbindEmailQuotedTextPatterns(EmailQuotedTextPatterns emailQuotedTextPatterns) {
        if (this.emailQuotedTextPatterns == emailQuotedTextPatterns) {
            this.emailQuotedTextPatterns = null;
        }
    }
}

