/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply.impl;

import com.adobe.cq.social.commons.emailreply.EmailQuotedTextPatterns;
import java.util.Dictionary;
import java.util.regex.Matcher;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%emailQuotedTextPatterns.name", description="%emailQuotedTextPatterns.description", immediate=true, metatype=true)
@Service
public class EmailQuotedTextPatternsImpl
implements EmailQuotedTextPatterns {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailQuotedTextPatterns.class);
    private static final String newlinePattern = "(\n|\r\n)";
    private static final String spacePattern = "(\\s)";
    private static final String dateSpacePattern = "[\\s,/\\.\\-]";
    @Property(value={"(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:%SPACE%)?[AP]M)?"})
    private static final String TIME_PATTERN_PROPERTY = "pattern.time";
    @Property(value={"(?:(?:Mon(?:day)?)|(?:Tue(?:sday)?)|(?:Wed(?:nesday)?)|(?:Thu(?:rsday)?)|(?:Fri(?:day)?)|(?:Sat(?:urday)?)|(?:Sun(?:day)?))"})
    private static final String DAY_PATTERN_PROPERTY = "pattern.newline";
    @Property(value={"[0-3]?[0-9]%DATE_SPACE%*(?:(?:th)|(?:st)|(?:nd)|(?:rd))?"})
    private static final String DAY_OF_MONTH_PATTERN_PROPERTY = "pattern.dayOfMonth";
    @Property(value={"(?:(?:Jan(?:uary)?)|(?:Feb(?:uary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|(?:May)|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)|(?:[0-1]?[0-9]))"})
    private static final String MONTH_PATTERN_PROPERTY = "pattern.month";
    @Property(value={"(?:[1-2]?[0-9])[0-9][0-9]"})
    private static final String YEAR_PATTERN_PROPERTY = "pattern.year";
    @Property(value={"(?:%DAY%%DATE_SPACE%+)?(?:(?:%DAY_OF_MONTH%%DATE_SPACE%+%MONTH%)|(?:%MONTH%%DATE_SPACE%+%DAY_OF_MONTH%))%DATE_SPACE%+%YEAR%"})
    private static final String DATE_PATTERN_PROPERTY = "pattern.date";
    @Property(value={"(?:%DATE%[%DATE_SPACE%]*(?:(?:at)|(?:@))?%SPACE%*%TIME%)|(?:%TIME%[%DATE_SPACE%]*(?:on)?%SPACE%*%DATE%)"})
    private static final String DATE_TIME_PATTERN_PROPERTY = "pattern.dateTime";
    @Property(value={"%SPACE%*[^%SPACE%]+@[^%SPACE%]+%SPACE%*"})
    private static final String EMAIL_PATTERN_PROPERTY = "pattern.email";
    private static String timePattern;
    private static String dayPattern;
    private static String dayOfMonthPattern;
    private static String monthPattern;
    private static String yearPattern;
    private static String datePattern;
    private static String dateTimePattern;
    private static String emailPattern;

    @Activate
    private void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        Object prop = props.get(TIME_PATTERN_PROPERTY);
        if (prop != null) {
            timePattern = prop.toString().trim();
        }
        if ((prop = props.get(DAY_PATTERN_PROPERTY)) != null) {
            dayPattern = prop.toString().trim();
        }
        if ((prop = props.get(DAY_OF_MONTH_PATTERN_PROPERTY)) != null) {
            dayOfMonthPattern = prop.toString().trim();
        }
        if ((prop = props.get(MONTH_PATTERN_PROPERTY)) != null) {
            monthPattern = prop.toString().trim();
        }
        if ((prop = props.get(YEAR_PATTERN_PROPERTY)) != null) {
            yearPattern = prop.toString().trim();
        }
        if ((prop = props.get(DATE_PATTERN_PROPERTY)) != null) {
            datePattern = prop.toString().trim();
        }
        if ((prop = props.get(DATE_TIME_PATTERN_PROPERTY)) != null) {
            dateTimePattern = prop.toString().trim();
        }
        if ((prop = props.get(EMAIL_PATTERN_PROPERTY)) != null) {
            emailPattern = prop.toString().trim();
        }
        LOGGER.debug("Activating {}.", (Object)this.getClass().getName());
    }

    public String decomposePattern(String pattern) {
        return pattern.replaceAll("%EMAIL%", Matcher.quoteReplacement(emailPattern)).replaceAll("%DATE_TIME%", Matcher.quoteReplacement(dateTimePattern)).replaceAll("%DATE%", Matcher.quoteReplacement(datePattern)).replaceAll("%YEAR%", Matcher.quoteReplacement(yearPattern)).replaceAll("%MONTH%", Matcher.quoteReplacement(monthPattern)).replaceAll("%DAY_OF_MONTH%", Matcher.quoteReplacement(dayOfMonthPattern)).replaceAll("%DAY%", Matcher.quoteReplacement(dayPattern)).replaceAll("%TIME%", Matcher.quoteReplacement(timePattern)).replaceAll("%DATE_SPACE%", Matcher.quoteReplacement(dateSpacePattern)).replaceAll("%SPACE%", Matcher.quoteReplacement(spacePattern)).replaceAll("%NEWLINE%", Matcher.quoteReplacement(newlinePattern));
    }
}

