/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply.impl;

import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.emailreply.EmailClientProvider;
import com.adobe.cq.social.commons.emailreply.EmailReplyException;
import com.adobe.cq.social.commons.emailreply.EmailReplyService;
import com.adobe.cq.social.commons.emailreply.impl.AbstractEmailClientProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%emailreplyserviceimpl.name", description="%emailreplyserviceimpl.description", immediate=true, metatype=true)
@Service(value={EmailReplyService.class})
public class EmailReplyServiceImpl
implements EmailReplyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailReplyServiceImpl.class);
    private static final String OPTION_REPLY_TO = "replyTo";
    private static final String OPTION_SUBJECT = "subject";
    private static final String DEFAULT_TOPIC_ID_PREFIX_IN_SUBJECT = "topic#";
    private static final int DEFAULT_SUBJECT_LENGTH = 200;
    private static final String DEFAULT_REPLY_TO_DELIMITER = "+";
    @Property(value={"subject"}, options={@PropertyOption(name="replyTo", value="Reply-To"), @PropertyOption(name="subject", value="Subject")})
    private static final String ADD_TOPIC_ID_TO = "addTopicIdTo";
    @Property(value={"topic#"})
    private static final String TOPIC_ID_PREFIX_IN_SUBJECT = "subject.topicIdPrefix";
    @Property(intValue={200})
    private static final String SUBJECT_MAXIMUM_LENGTH = "email.subjectMaximumLength";
    @Property(value={"+"})
    private static final String REPLY_TO_DELIMITER = "replyToDelimiter";
    private String addTopicIdTo = "subject";
    private String topicIdPrefixInSubject = "topic#";
    private int subjectMaximumLength = 200;
    private String replyToDelimiter = "+";
    private BundleContext bundleContext;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Activate
    protected void activate(ComponentContext context) {
        LOGGER.info("Activating {}.", (Object)this.getClass().getName());
        this.bundleContext = context.getBundleContext();
        this.configure(context);
    }

    private void configure(ComponentContext context) {
        Dictionary props = context.getProperties();
        Object prop = props.get(ADD_TOPIC_ID_TO);
        if (prop != null) {
            this.addTopicIdTo = OsgiUtil.toString(prop, (String)OPTION_SUBJECT);
        }
        if ((prop = props.get(TOPIC_ID_PREFIX_IN_SUBJECT)) != null) {
            this.topicIdPrefixInSubject = OsgiUtil.toString(prop, (String)DEFAULT_TOPIC_ID_PREFIX_IN_SUBJECT);
        }
        if ((prop = props.get(SUBJECT_MAXIMUM_LENGTH)) != null) {
            this.subjectMaximumLength = OsgiUtil.toInteger(prop, (int)200);
            if (this.subjectMaximumLength < 0) {
                this.subjectMaximumLength = 200;
            }
        }
        if ((prop = props.get(REPLY_TO_DELIMITER)) != null) {
            this.replyToDelimiter = OsgiUtil.toString(prop, (String)DEFAULT_REPLY_TO_DELIMITER);
        }
    }

    @Override
    public Email addTrackerId(Session adminSession, Email email, String topicPath) {
        if (email != null) {
            if (this.addTopicIdTo.equals(OPTION_REPLY_TO)) {
                Collection<InternetAddress> replyToAddresses = this.getReplyToWithTopicId(adminSession, email.getFromAddress().getAddress(), topicPath);
                if (replyToAddresses != null && !replyToAddresses.isEmpty()) {
                    try {
                        LOGGER.debug("Adding topic Id to replyTo address for topic {}", (Object)topicPath);
                        email.setReplyTo(replyToAddresses);
                    }
                    catch (EmailException e) {
                        List recipients = email.getToAddresses();
                        String addressTo = recipients.size() > 0 ? recipients.get(0).toString() : "";
                        LOGGER.error("error while setting Reply-To field in notification email to user : " + addressTo, (Throwable)e);
                    }
                }
            } else if (this.addTopicIdTo.equals(OPTION_SUBJECT)) {
                LOGGER.debug("Adding topic Id to subject for topic {}", (Object)topicPath);
                String subject = this.getSubjectWithTopicId(adminSession, email.getSubject(), topicPath);
                email.setSubject(subject);
            }
        }
        return email;
    }

    private String getSubjectWithTopicId(Session adminSession, String originalSubject, String topicPath) {
        String subject = originalSubject;
        if (null == subject) {
            subject = "";
        }
        String topicUniqueId = "";
        if (StringUtils.isNotBlank((String)topicPath)) {
            try {
                topicUniqueId = this.getTopicUniqueId(adminSession, topicPath);
                LOGGER.debug("Found topic unique Id {} to be added to subject.", (Object)topicUniqueId);
            }
            catch (RepositoryException e) {
                LOGGER.error("unable to access topic node or properties for topic [{}]", (Object)topicPath);
            }
        }
        if (StringUtils.isNotBlank((String)topicUniqueId)) {
            if (subject.length() > this.subjectMaximumLength) {
                subject = subject.substring(0, this.subjectMaximumLength) + "...";
            }
            subject = subject + " [" + this.getTopicIdPrefixInSubject() + topicUniqueId + "]";
            LOGGER.debug("Modifying subject to {}", (Object)subject);
        } else {
            LOGGER.error("unable to get topic unique id for topic : [{}]", (Object)topicPath);
        }
        return subject;
    }

    private Collection<InternetAddress> getReplyToWithTopicId(Session adminSession, String fromAddress, String topicPath) {
        String topicUniqueId = "";
        if (StringUtils.isNotBlank((String)topicPath)) {
            try {
                topicUniqueId = this.getTopicUniqueId(adminSession, topicPath);
                LOGGER.debug("Found topic unique Id {} to be added to replyTo.", (Object)topicUniqueId);
            }
            catch (RepositoryException e) {
                LOGGER.error("unable to access topic node or properties for topic : [{}]", (Object)topicPath);
            }
        }
        if (StringUtils.isNotBlank((String)topicUniqueId)) {
            String newAddress = fromAddress.substring(0, fromAddress.indexOf("@")) + this.getReplyToDelimiter() + topicUniqueId + fromAddress.substring(fromAddress.indexOf("@"));
            try {
                LOGGER.debug("Modifying ReplyTo address to {}", (Object)newAddress);
                return Collections.singletonList(new InternetAddress(newAddress));
            }
            catch (AddressException e) {
                LOGGER.error("Error while creating reply-to header email addresses.", (Throwable)e);
            }
        } else {
            LOGGER.error("unable to get topic unique id for topic : [{}]", (Object)topicPath);
        }
        return Collections.emptyList();
    }

    private String getTopicUniqueId(Session session, String topicPath) throws RepositoryException {
        String tid = "";
        Node topicNode = session.getNode(topicPath);
        if (topicNode.hasProperty("topicUniqueId")) {
            tid = topicNode.getProperty("topicUniqueId").getString();
        } else {
            tid = this.getShortTicket(topicPath);
            topicNode.setProperty("topicUniqueId", tid);
            topicNode.getSession().save();
        }
        return tid;
    }

    private String getShortTicket(String assertion) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String shortTicket = new String(Hex.encodeHex((byte[])digest.digest(assertion.getBytes())));
            return shortTicket;
        }
        catch (NoSuchAlgorithmException e1) {
            CRC32 crc = new CRC32();
            crc.update(assertion.getBytes());
            byte[] bytes = new byte[4];
            long value = crc.getValue();
            bytes[0] = (byte)(value & 0xFFL);
            bytes[1] = (byte)((value >>>= 4) & 0xFFL);
            bytes[2] = (byte)((value >>>= 4) & 0xFFL);
            bytes[3] = (byte)((value >>>= 4) & 0xFFL);
            String shortTicket = new String(Hex.encodeHex((byte[])bytes));
            return shortTicket;
        }
    }

    @Override
    public Properties getMailProperties(Session adminSession, InputStream mailStream, boolean postOriginalOnFailure, String topicResourceType) {
        return this.getMailProperties(adminSession, mailStream, postOriginalOnFailure, topicResourceType, "cq:Comment", "/content/usergenerated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getMailProperties(Session adminSession, InputStream mailStream, boolean postOriginalOnFailure, String topicResourceType, String topicNodeType, String topicRootPath) {
        Properties properties = new Properties();
        StringBuilder statusMsg = new StringBuilder("");
        try {
            MimeMessage mail = this.getMailFromStream(mailStream);
            EmailClientProvider emailClientProvider = this.getEmailClientProvider(mail);
            if (emailClientProvider == null) {
                statusMsg.append("No suitable email client provider found.");
                if (!postOriginalOnFailure) {
                    statusMsg.append(" ").append("Discarding the message.");
                    throw new EmailReplyException(statusMsg.toString());
                }
                emailClientProvider = new AbstractEmailClientProvider(){

                    protected String getMessage(MimeMessage mailMessage) throws IOException, MessagingException {
                        return super.getEmailContent(mailMessage);
                    }
                };
                statusMsg.append(" ").append("Accepting the original message which might contain quoted text.");
            } else {
                statusMsg.append("Contents parsed by : " + emailClientProvider.getClass().getName());
            }
            Properties mailProperties = emailClientProvider.getMailProperties(mail);
            String topicUniqueId = this.getTopicUniqueIdFromMail(mail);
            if (StringUtils.isBlank((String)topicUniqueId)) {
                statusMsg.append(" ").append("Unable to parse topic unique id.");
                throw new EmailReplyException(statusMsg.toString());
            }
            String topicPath = this.getTopicPath(topicUniqueId, adminSession, topicResourceType, topicNodeType, topicRootPath);
            if (StringUtils.isBlank((String)topicPath)) {
                statusMsg.append(" ").append("Unable to track the topic.");
                throw new EmailReplyException(statusMsg.toString());
            }
            properties.setProperty("email.message", mailProperties.getProperty("email.message"));
            properties.setProperty("email.author", mailProperties.getProperty("email.author.id"));
            properties.setProperty("topic.resourcePath", topicPath);
            LOGGER.debug(statusMsg.toString());
            return properties;
        }
        catch (CommentException e) {
            throw new CommentException(e.getMessage());
        }
        catch (MessagingException e) {
            throw new EmailReplyException("Unable to construct MIME message from inputstream. " + e.getMessage());
        }
    }

    private ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    @Override
    public String getTopicPath(String topicUniqueId, Session adminSession, String topicResourceType, String topicNodeType, String topicRootPath) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT * FROM [" + topicNodeType + "] AS s WHERE ");
        queryBuilder.append("ISDESCENDANTNODE(s, [\"" + topicRootPath + "\"]) AND ");
        queryBuilder.append("s.[topicUniqueId] ='").append(topicUniqueId).append("'");
        String queryString = queryBuilder.toString();
        LOGGER.debug("Built query : {}", (Object)queryString);
        if (!queryString.isEmpty()) {
            try {
                Iterator topicResourceItr = this.getResourceResolver(adminSession).findResources(queryString, "JCR-SQL2");
                while (topicResourceItr.hasNext()) {
                    Resource topicResource = (Resource)topicResourceItr.next();
                    if (!topicResource.isResourceType(topicResourceType)) continue;
                    return topicResource.getPath();
                }
            }
            catch (LoginException e) {
                LOGGER.error("Unable to get resource resolver with this session.");
            }
            catch (SlingException e) {
                LOGGER.error("Error while querying for topic.", (Throwable)e);
            }
        }
        return null;
    }

    private MimeMessage getMailFromStream(InputStream mailFileStream) throws MessagingException {
        Properties props = System.getProperties();
        javax.mail.Session mailSession = javax.mail.Session.getDefaultInstance((Properties)props, null);
        return new MimeMessage(mailSession, mailFileStream);
    }

    private EmailClientProvider getEmailClientProvider(MimeMessage mail) {
        List<EmailClientProvider> emailClientProviders = this.getEmailClientProviderList();
        for (EmailClientProvider emailClientProvider : emailClientProviders) {
            boolean mailAccepted = emailClientProvider.acceptsMail(mail);
            LOGGER.debug("Going through Email Client Provider {} to see if this accepts mail {}.", (Object)emailClientProvider.getClass().getName(), (Object)mailAccepted);
            if (!mailAccepted) continue;
            return emailClientProvider;
        }
        return null;
    }

    private List<EmailClientProvider> getEmailClientProviderList() {
        ArrayList<EmailClientProvider> emailClientProviders = new ArrayList<EmailClientProvider>();
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(EmailClientProvider.class.getName(), null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    EmailClientProvider emailClientProvider = (EmailClientProvider)this.bundleContext.getService(ref);
                    emailClientProviders.add(emailClientProvider);
                }
                Collections.sort(emailClientProviders, new Comparator<EmailClientProvider>(){

                    @Override
                    public int compare(EmailClientProvider p1, EmailClientProvider p2) {
                        Integer priority1 = p1.getPriorityOrder();
                        Integer priority2 = p2.getPriorityOrder();
                        return priority1.compareTo(priority2);
                    }
                });
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("could not look up email client provider services: {}", (Throwable)e);
        }
        return emailClientProviders;
    }

    private String getTopicUniqueIdFromMail(MimeMessage mailMessage) throws MessagingException {
        Pattern pattern;
        Matcher m;
        String topicUniqueId = "";
        String subject = mailMessage.getSubject();
        if (subject != null && (m = (pattern = Pattern.compile("(\\[" + this.getTopicIdPrefixInSubject() + ")([a-zA-Z0-9]+)(\\])")).matcher(subject)).find()) {
            LOGGER.debug("Found unique topic Id in subject: {}", (Object)topicUniqueId);
            return m.group(2);
        }
        Address[] recipients = mailMessage.getRecipients(Message.RecipientType.TO);
        if (recipients != null && recipients.length > 0) {
            int replyToDelimiterIndex;
            String recipientAddressStr = recipients[0].toString();
            if (recipientAddressStr.contains("<") && recipientAddressStr.contains(">")) {
                recipientAddressStr = recipientAddressStr.substring(recipientAddressStr.indexOf("<") + 1, recipientAddressStr.indexOf(">"));
            }
            if ((replyToDelimiterIndex = recipientAddressStr.indexOf(this.getReplyToDelimiter())) != -1) {
                topicUniqueId = recipientAddressStr.substring(replyToDelimiterIndex + 1, recipientAddressStr.indexOf("@"));
                LOGGER.debug("Found unique topic Id in recipient Address: {}", (Object)topicUniqueId);
            }
        }
        return topicUniqueId;
    }

    private String getTopicIdPrefixInSubject() {
        return this.topicIdPrefixInSubject;
    }

    private String getReplyToDelimiter() {
        return this.replyToDelimiter;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

