/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply.impl;

import com.adobe.cq.social.commons.emailreply.impl.AbstractEmailClientProvider;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%outlookemailclientprovider.name", description="%outlookemailclientprovider.description", immediate=true, metatype=true)
@Service
public class OutLookEmailClientProvider
extends AbstractEmailClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutLookEmailClientProvider.class);
    private static final String defaultPattern1 = "---+Original%SPACE%+Message---+%NEWLINE%";
    private static final String defaultPattern2 = "From:%SPACE%*.*mailto:";
    private static final String defaultPattern3 = "From:(.*%NEWLINE%)+Sent:";
    @Property(intValue={6})
    protected static final String PRIORITY_ORDER = "priorityOrder";
    @Property(value={"---+Original%SPACE%+Message---+%NEWLINE%", "From:%SPACE%*.*mailto:", "From:(.*%NEWLINE%)+Sent:"}, cardinality=0x7FFFFFFF)
    protected static final String REPLY_EMAIL_PATTERNS = "replyEmailPatterns";

    @Activate
    protected void activate(ComponentContext context) {
        super.configure(context);
        this.patterns.add(Pattern.compile(this.emailQuotedTextPatterns.decomposePattern(defaultPattern1)));
        this.patterns.add(Pattern.compile(this.emailQuotedTextPatterns.decomposePattern(defaultPattern2)));
        this.patterns.add(Pattern.compile(this.emailQuotedTextPatterns.decomposePattern(defaultPattern3)));
        LOGGER.debug("Activating {}.", (Object)this.getClass().getName());
    }

    @Modified
    protected void modify(ComponentContext context) {
        super.configure(context);
        LOGGER.debug("Modifying {}.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        LOGGER.debug("Deactivating {}.", (Object)this.getClass().getName());
    }
}

