/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.events;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocialEvent<T extends SocialActions>
extends Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String USER_ID = "userId";
    protected static final String ACTION = "action";
    protected static final String PATH = "path";
    public static final String SOCIAL_EVENT_TOPIC_PREFIX = "adobe/cq/social/";

    public SocialEvent(Event event) {
        super(event.getTopic(), SocialEvent.buildPropertiesFromEvent(event));
    }

    private static Dictionary<String, Object> buildPropertiesFromEvent(Event event) {
        Hashtable<String, Object> props = new Hashtable<String, Object>(event.getPropertyNames().length);
        for (String key : event.getPropertyNames()) {
            ((Dictionary)props).put(key, event.getProperty(key));
        }
        return props;
    }

    public SocialEvent(String topic, String path, String userId, T action, Map<String, Object> additionalData) {
        super(SOCIAL_EVENT_TOPIC_PREFIX + topic, SocialEvent.buildProps(path, userId, action, additionalData));
    }

    private static Dictionary<String, Object> buildProps(String path, String userId, SocialActions action, Map<String, Object> additionalData) {
        int size = 3;
        if (null != additionalData) {
            size += additionalData.size();
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>(size);
        if (null != additionalData) {
            for (Map.Entry<String, Object> datum : additionalData.entrySet()) {
                ((Dictionary)props).put(datum.getKey(), datum.getValue());
            }
        }
        ((Dictionary)props).put(PATH, path);
        ((Dictionary)props).put(ACTION, action);
        ((Dictionary)props).put(USER_ID, userId);
        return props;
    }

    public String getUserId() {
        return (String)this.getProperty(USER_ID);
    }

    public T getAction() {
        return (T)((SocialActions)this.getProperty(ACTION));
    }

    public String getPath() {
        return (String)this.getProperty(PATH);
    }

    public static interface SocialActions {
    }
}

