/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.AsyncReverseReplicator;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL, label="%asyncreversereplicator.name", description="%asyncreversereplicator.description")
@Service(value={AsyncReverseReplicator.class})
public class AysncReverseReplicatorImpl
implements AsyncReverseReplicator {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference
    protected Replicator replicator;
    private Session adminSession;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final int DEFAULT_POOL_SIZE = 5;
    protected static final int DEFAULT_MAX_POOL_SIZE = 10;
    protected static final int DEFAULT_QUEUE_SIZE = 50;
    protected static final long DEFAULT_KEEP_ALIVE_TIME = 1L;
    @Property(intValue={5})
    public static final String PROPERTY_POOL_SIZE = "poolSize";
    @Property(intValue={10})
    public static final String PROPERTY_MAX_POOL_SIZE = "maxPoolSize";
    @Property(intValue={50})
    public static final String PROPERTY_QUEUE_SIZE = "queueSize";
    @Property(longValue={1L})
    public static final String PROPERTY_KEEP_ALIVE = "keepAliveTime";
    protected ExecutorService executorService;
    public static final AgentFilter REV_AGENT_FILTER = new AgentFilter(){

        public boolean isIncluded(Agent agent) {
            return agent.getConfiguration().isTriggeredOnDistribute();
        }
    };

    @Override
    public void reverseReplicate(String path) {
        this.reverseReplicate(ReplicationActionType.ACTIVATE, path);
    }

    @Override
    public final void reverseReplicate(final ReplicationActionType actionType, final String path) {
        this.executorService.submit(new Runnable(){

            public void run() {
                ReplicationOptions opts = new ReplicationOptions();
                opts.setFilter(REV_AGENT_FILTER);
                try {
                    List paths = AysncReverseReplicatorImpl.this.getPaths(AysncReverseReplicatorImpl.this.adminSession, path);
                    for (String subPath : paths) {
                        AysncReverseReplicatorImpl.this.replicator.replicate(AysncReverseReplicatorImpl.this.adminSession, actionType, subPath, opts);
                    }
                }
                catch (ReplicationException e) {
                    AysncReverseReplicatorImpl.this.log.error("Error while triggering reverse replication of {}", (Object)path, (Object)e);
                }
            }
        });
    }

    @Override
    public final void reverseReplicate(final ReplicationActionType actionType, final List<String> paths) {
        this.executorService.submit(new Runnable(){

            public void run() {
                ReplicationOptions opts = new ReplicationOptions();
                opts.setFilter(REV_AGENT_FILTER);
                try {
                    for (String subPath : paths) {
                        AysncReverseReplicatorImpl.this.replicator.replicate(AysncReverseReplicatorImpl.this.adminSession, actionType, subPath, opts);
                    }
                }
                catch (ReplicationException e) {
                    AysncReverseReplicatorImpl.this.log.error("Error while triggering reverse replication of {}", (Object)paths.toString(), (Object)e);
                }
            }
        });
    }

    private List<String> getPaths(Session session, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        Node node = (Node)this.jcrResourceResolverFactory.getResourceResolver(session).getResource(path).adaptTo(Node.class);
        paths.add(path);
        try {
            if (node.hasNode("attachments")) {
                Node attNode = node.getNode("attachments");
                NodeIterator iter = attNode.getNodes();
                while (iter.hasNext()) {
                    paths.add(iter.nextNode().getPath());
                }
            }
        }
        catch (PathNotFoundException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        catch (RepositoryException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        return paths;
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        if (this.repository == null) {
            throw new RepositoryException("Unsatisfied Reference to SlingRepository");
        }
        this.adminSession = this.repository.loginAdministrative(null);
        int poolSize = OsgiUtil.toInteger(context.getProperties().get(PROPERTY_POOL_SIZE), (int)5);
        int maxPoolSize = OsgiUtil.toInteger(context.getProperties().get(PROPERTY_MAX_POOL_SIZE), (int)10);
        int queueSize = OsgiUtil.toInteger(context.getProperties().get(PROPERTY_QUEUE_SIZE), (int)50);
        long keepAlive = OsgiUtil.toLong(context.getProperties().get(PROPERTY_KEEP_ALIVE), (long)1L);
        this.executorService = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAlive, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(queueSize, true), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deactivate(ComponentContext context) {
        if (this.adminSession != null) {
            this.adminSession.logout();
            this.adminSession = null;
        }
        if (this.executorService == null) return;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
            if (this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

