/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.impl.CommentImpl;
import com.adobe.cq.social.commons.impl.CommentSystemImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Default Social Collab Adapter"})})
public class CollabAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(CollabAdapterFactory.class);
    private static final Class<Comment> COMMENT_CLASS = Comment.class;
    private static final Class<CommentSystem> COMMENT_SYSTEM_CLASS = CommentSystem.class;
    @Property(name="adapters")
    public static final String[] ADAPTER_CLASSES = new String[]{COMMENT_CLASS.getName(), COMMENT_SYSTEM_CLASS.getName()};
    @Property(name="adaptables")
    public static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName()};
    private String bundleVersion;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        try {
            if (type == COMMENT_SYSTEM_CLASS) {
                return (AdapterType)new CommentSystemImpl(resource);
            }
            if (type == COMMENT_CLASS) {
                return (AdapterType)new CommentImpl(resource);
            }
            log.debug("Unable to adapt resource to requested type {}", (Object)type.getName());
            return null;
        }
        catch (CommentException be) {
            log.debug("Unable to adapt resource to requested type {}", (Object)type.getName());
            return null;
        }
    }

    protected void activate(ComponentContext context) {
        this.bundleVersion = (String)context.getBundleContext().getBundle().getHeaders().get("Bundle-Version");
    }
}

