/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabException;
import com.adobe.cq.social.commons.CollabUser;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollabUserImpl
implements CollabUser {
    public static final Logger log = LoggerFactory.getLogger(CollabUserImpl.class);
    private final Resource resource;
    private final String id;
    private String name;
    private String website;
    private String email;
    private boolean dirty;

    public CollabUserImpl(Resource r) {
        ValueMap properties = (ValueMap)r.adaptTo(ValueMap.class);
        this.id = (String)properties.get("userIdentifier", (Object)"Anonymous");
        this.email = (String)properties.get("email", (Object)"");
        this.website = (String)properties.get("url", (Object)"");
        this.resource = r;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public void setName(String n) {
        if (!this.getEmail().equals(n)) {
            try {
                ((Node)this.resource.adaptTo(Node.class)).setProperty("userIdentifier", n);
                this.dirty = true;
                this.name = n;
            }
            catch (Exception e) {
                log.error("failed to set name", (Throwable)e);
            }
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String em) {
        if (!this.getEmail().equals(em)) {
            try {
                ((Node)this.resource.adaptTo(Node.class)).setProperty("email", em);
                this.dirty = true;
                this.email = em;
            }
            catch (Exception e) {
                log.error("failed to set email", (Throwable)e);
            }
        }
    }

    public String getWebsite(String defaultUrl) {
        return !"".equals(this.website) ? this.website : defaultUrl;
    }

    public void setWebsite(String ws) {
        if (!this.getWebsite("").equals(ws)) {
            try {
                ((Node)this.resource.adaptTo(Node.class)).setProperty("url", ws);
                this.dirty = true;
                this.website = ws;
            }
            catch (Exception e) {
                log.error("failed to set website", (Throwable)e);
            }
        }
    }

    public String getGravatar(String defaultImage) {
        try {
            if (this.email != null && !"".equals(this.email)) {
                return "http://www.gravatar.com/avatar/" + Text.md5((String)this.email, (String)"utf-8") + "?d=" + Text.escape((String)defaultImage) + "&r=g";
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return defaultImage;
    }

    public boolean isModified() {
        return this.dirty;
    }

    public void save() throws CollabException {
        try {
            ((Session)this.resource.getResourceResolver().adaptTo(Session.class)).save();
        }
        catch (Exception e) {
            throw new CollabException("failed to save user", e);
        }
    }
}

