/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.impl.CommentInfo;
import com.adobe.cq.social.commons.impl.CommentIterable;
import com.adobe.cq.social.commons.impl.LazyLoadedCommentList;
import com.adobe.cq.social.commons.index.impl.comment.CommentIndexManager;
import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import com.adobe.cq.social.storage.index.IndexUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.text.Text;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommentBase {
    private static final String SLING_FOLDER = "sling:Folder";
    private static final Logger log = LoggerFactory.getLogger(CommentBase.class);
    public static final String SUFFIX_HTML = ".html";
    static final String PN_COMMENT_RESOURCETYPE = "commentresourcetype";
    protected ResourceResolver resolver;
    protected CommentSystem cs;
    protected String id;
    protected CommentInfo commentInfo;
    protected String bucketPostfix;
    private long allIndexSize = -1L;
    private long filteredIndexSize = -1L;

    public String getId() {
        return this.id;
    }

    public Iterator<Comment> getComments() {
        return new CommentIterable(this.commentInfo.getResource(), this.getBucketPostfix()).iterator();
    }

    public List<Comment> getCommentList() {
        return new LazyLoadedCommentList(this.commentInfo.getResource(), this.commentInfo.getComponent());
    }

    public int countComments() {
        return this.countComments(WCMMode.DISABLED);
    }

    private void initIndex() {
        if (this.allIndexSize != -1L) {
            return;
        }
        Resource resource = this.commentInfo.getResource();
        try {
            String indexPath = IndexUtil.getBaseIndexFolder((ResourceResolver)this.resolver, (String)resource.getPath());
            CommentIndexManager indexManager = CommentIndexManager.getInstance(this.resolver, indexPath, false);
            if (ResourceUtil.isA((Resource)resource, (String)"social/commons/components/comments/comment")) {
                String relPath = CommentIndexManager.getCommentRelativePath(resource.getPath());
                indexManager.initCommentReplyIndexer(relPath, this.resolver, false);
                this.allIndexSize = indexManager.getSize(relPath + "all", this.resolver);
                this.filteredIndexSize = indexManager.getSize(relPath + "filtered", this.resolver);
            } else {
                this.allIndexSize = indexManager.getSize("all", this.resolver);
                this.filteredIndexSize = indexManager.getSize("filtered", this.resolver);
            }
        }
        catch (RepositoryException e) {
            log.error("Error initializing counts from index for " + resource.getPath(), (Throwable)e);
        }
    }

    public int countComments(WCMMode wcmMode) {
        if (!ResourceUtil.isNonExistingResource((Resource)this.commentInfo.getResource())) {
            this.initIndex();
            if (wcmMode == WCMMode.EDIT || !CommentUtil.isSystemModerated(this.commentInfo.getComponent())) {
                return (int)this.allIndexSize;
            }
            return (int)(this.allIndexSize - this.filteredIndexSize);
        }
        log.info("User generated content resource does not exist: " + this.commentInfo.getResource().getPath());
        return 0;
    }

    public void save() {
        CollabUtil.save(this.resolver);
    }

    protected boolean doCountComments(WCMMode wcmMode, Resource resource) {
        return wcmMode == WCMMode.EDIT || CommentUtil.isApproved(resource, this.commentInfo.getComponent());
    }

    public boolean hasComments() {
        return this.hasComments(WCMMode.DISABLED);
    }

    public boolean hasComments(WCMMode wcmMode) {
        return this.countComments(wcmMode) > 0;
    }

    protected Comment createComment(String message, String author) throws CommentException {
        return this.createComment(message, author, null);
    }

    protected Comment createComment(String message, String author, List<DataSource> fileAttachments) throws CommentException {
        return this.createComment(CommentBase.createUniqueNameHint(message), message, author, fileAttachments);
    }

    static String createUniqueNameHint(String message) throws CommentException {
        StringBuilder nodeName;
        try {
            nodeName = new StringBuilder(CollabUtil.generateRandomString(4)).append("-");
            message = message.replaceAll("\\<.*?>", "");
            message = message.replaceAll("\\&.*?\\;", "");
            if (message.length() > 20) {
                nodeName.append(message.substring(0, 20));
            } else {
                nodeName.append(message);
            }
        }
        catch (Exception e) {
            throw new CommentException("failed to create unique name.", e);
        }
        String uniqueName = JcrUtil.createValidName((String)nodeName.toString());
        return uniqueName.replace("__", "-");
    }

    protected Comment createComment(String uniqueNameHint, String message, String author, List<DataSource> fileAttachments) throws CommentException {
        if (uniqueNameHint == null) {
            throw new IllegalArgumentException("uniqueNameHint can not be null.");
        }
        if (author == null) {
            throw new IllegalArgumentException("author can not be null.");
        }
        try {
            Designer commentDesign;
            Resource resource = this.commentInfo.getResource();
            NestedBucketStorageSystem bucketSystem = this.getBucketSystem(resource);
            Node node = bucketSystem.addNode(JcrUtil.createValidName((String)uniqueNameHint), "cq:Comment");
            node.setProperty("sling:resourceType", "social/commons/components/comments/comment");
            Resource r = this.resolver.getResource(this.commentInfo.getComponent().getPath());
            if (null != r && null != (commentDesign = (Designer)this.resolver.adaptTo(Designer.class))) {
                Style currentStyle = null;
                try {
                    currentStyle = commentDesign.getStyle(r);
                }
                catch (NullPointerException e) {
                    log.info("Null pointer exception caught while searching for design for the resource at: " + r.getPath());
                    currentStyle = null;
                }
                if (null != currentStyle && StringUtils.equals((String)this.commentInfo.getComponent().getResourceType(), (String)((String)currentStyle.get((Object)"sling:resourceType")))) {
                    String commentResourceType = (String)currentStyle.get(PN_COMMENT_RESOURCETYPE, (Object)"social/commons/components/comments/comment");
                    node.setProperty("sling:resourceType", commentResourceType);
                }
            }
            node.setProperty("jcr:description", message);
            node.setProperty("authorizableId", author);
            Comment comment = (Comment)this.resolver.resolve(node.getPath()).adaptTo(Comment.class);
            if (fileAttachments != null) {
                for (DataSource fileAttachment : fileAttachments) {
                    if (fileAttachment == null || fileAttachment.getInputStream().available() <= 0) continue;
                    try {
                        comment.addAttachment(fileAttachment.getName(), fileAttachment.getInputStream(), fileAttachment.getContentType());
                    }
                    catch (Exception e) {
                        log.error("Failed to create comment: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            comment.getAuthor().setName(author);
            this.touchUserGeneratedContent();
            return comment;
        }
        catch (Exception e) {
            throw new CommentException("failed to create comment", e);
        }
    }

    protected NestedBucketStorageSystem getBucketSystem(Resource resource) {
        NestedBucketStorageSystem bucketSystem = (NestedBucketStorageSystem)resource.adaptTo(NestedBucketStorageSystem.class);
        bucketSystem.setBucketPostfix(this.getBucketPostfix());
        return bucketSystem;
    }

    protected String assembleCommentId() {
        String id = Text.getName((String)this.commentInfo.getComponent().getPath());
        if (id.indexOf(".") != -1) {
            id = id.substring(0, id.indexOf("."));
        }
        String path = this.commentInfo.getResource().getPath().substring(0, this.commentInfo.getRootPath().length());
        StringTokenizer ids = new StringTokenizer(this.commentInfo.getResource().getPath().substring(this.commentInfo.getRootPath().length()), "/");
        try {
            while (ids.hasMoreElements()) {
                Property primaryType;
                String nextToken = ids.nextToken();
                Resource resource = this.resolver.getResource(path = path + "/" + nextToken);
                if (resource == null || !(primaryType = ((Node)resource.adaptTo(Node.class)).getProperty("jcr:primaryType")).getString().equals("cq:Comment")) continue;
                id = id + "__" + nextToken;
            }
        }
        catch (RepositoryException e) {
            log.error("Error assembleComponentId for" + this.commentInfo.getResource().getPath(), (Throwable)e);
            return null;
        }
        return id;
    }

    protected Resource findCommentSystemRoot() {
        Node node = (Node)this.commentInfo.getResource().adaptTo(Node.class);
        Resource res = null;
        try {
            while (node.isNodeType("cq:Comment") || node.isNodeType(SLING_FOLDER)) {
                Resource parentResource = this.resolver.getResource((node = node.getParent()).getPath());
                if (!ResourceUtil.isA((Resource)parentResource, (String)SLING_FOLDER)) continue;
                node = node.getParent();
            }
            res = this.resolver.getResource(node.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    protected void prepareUserGeneratedContent() throws CommentException {
        Resource root = this.commentInfo.getRoot();
        if (ResourceUtil.isNonExistingResource((Resource)root)) {
            try {
                try {
                    this.createUserGeneratedContent();
                }
                catch (ItemExistsException e) {
                    log.debug("ItemExitsException on " + root.getPath(), (Throwable)e);
                    Session session = (Session)this.resolver.adaptTo(Session.class);
                    session.refresh(false);
                    if (ResourceUtil.isNonExistingResource((Resource)root)) {
                        this.createUserGeneratedContent();
                    }
                }
            }
            catch (RepositoryException re) {
                throw new CommentException("failed to prepare user generated content", re);
            }
        }
    }

    protected void createUserGeneratedContent() throws RepositoryException {
        String ugcPagePath = CollabUtil.prepareUserGeneratedContent(this.resolver, this.commentInfo.getPagePath());
        Node pageNode = (Node)this.resolver.getResource(ugcPagePath).adaptTo(Node.class);
        Node contentNode = !pageNode.hasNode("jcr:content") ? pageNode.addNode("jcr:content", "cq:CommentContent") : pageNode.getNode("jcr:content");
        Node node = contentNode.addNode(Text.getName((String)this.getRoot().getPath()), "cq:CommentContent");
        node.setProperty("commentsNode", this.commentInfo.getComponent().getPath());
        this.save();
    }

    protected void touchUserGeneratedContent() throws CommentException {
        try {
            this.save();
            Node content = (Node)this.resolver.getResource(Text.getRelativeParent((String)this.getRoot().getPath(), (int)1)).adaptTo(Node.class);
            content.setProperty("cq:lastModified", Calendar.getInstance());
            content.setProperty("cq:lastModifiedBy", content.getSession().getUserID());
            Session session = (Session)this.resolver.adaptTo(Session.class);
            try {
                session.save();
            }
            catch (RepositoryException e) {
                log.debug("another thread already set modification date, not touching UGC.");
                session.refresh(false);
            }
        }
        catch (Exception e) {
            throw new CommentException("failed to touch page", e);
        }
    }

    protected Node addAttachmentNode(String name, Binary data, String contentType, String nodePath) throws CommentException {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            Node resNode;
            Node attNode;
            int pos;
            Node node = (Node)this.resolver.getResource(nodePath).adaptTo(Node.class);
            Node attsNode = !node.hasNode("attachments") ? JcrUtil.createUniqueNode((Node)node, (String)"attachments", (String)SLING_FOLDER, (Session)((Session)this.resolver.adaptTo(Session.class))) : node.getNode("attachments");
            if (!attsNode.isNodeType("mix:versionable")) {
                attsNode.addMixin("mix:versionable");
            }
            if (name == null) {
                name = "a" + System.currentTimeMillis() + ".bin";
            } else {
                pos = name.lastIndexOf(47);
                if (pos < 0) {
                    pos = name.lastIndexOf(92);
                }
                if (pos >= 0) {
                    name = name.substring(pos + 1);
                }
            }
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if ((pos = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, pos);
            }
            if (attsNode.hasNode(name)) {
                attNode = attsNode.getNode(name);
                resNode = attNode.getNode("jcr:content");
            } else {
                attNode = attsNode.addNode(name, "nt:file");
                resNode = attNode.addNode("jcr:content", "nt:resource");
            }
            resNode.setProperty("jcr:mimeType", contentType);
            resNode.setProperty("jcr:data", data);
            resNode.setProperty("jcr:lastModified", Calendar.getInstance());
            return attNode;
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                throw new CommentException("Repository error while adding attachment.", e);
            }
            throw new CommentException("Repository error while adding attachment.", e);
        }
    }

    protected void deleteAttachmentNode(String attPath) throws CommentException {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            String parentPath = this.commentInfo.getResource().getPath();
            if (!attPath.startsWith(parentPath)) {
                throw new CommentException("Unable to delete attachment. Attachment does not belong to this topic: " + parentPath);
            }
            Node attNode = (Node)session.getItem(attPath);
            attNode.remove();
            this.save();
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                throw new CommentException("Repository error while deleting attachment.", e);
            }
            throw new CommentException("Repository error while deleting attachment.", e);
        }
    }

    public String getBucketPostfix() {
        return null != this.bucketPostfix ? this.bucketPostfix : "Bucket";
    }

    public void setBucketPostfix(String bucketPostfix) {
        this.bucketPostfix = bucketPostfix;
    }

    public Resource getTarget() {
        return this.commentInfo.getTarget();
    }

    public Resource getRoot() {
        return this.commentInfo.getRoot();
    }
}

