/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.impl;

import com.adobe.cq.social.commons.CollabUser;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.impl.CollabUserImpl;
import com.adobe.cq.social.commons.impl.CommentBase;
import com.adobe.cq.social.commons.impl.CommentInfo;
import com.adobe.granite.comments.CommentCollection;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentImpl
extends CommentBase
implements Comment {
    private Externalizer externalizer;
    private static final Logger log = LoggerFactory.getLogger(Comment.class);

    public CommentImpl(Resource r) {
        if (r == null) {
            throw new CommentException("resource cannot be null");
        }
        if (ResourceUtil.isNonExistingResource((Resource)r) || ResourceUtil.isSyntheticResource((Resource)r)) {
            throw new CommentException("resource is non existent at " + r.getPath());
        }
        this.resolver = r.getResourceResolver();
        this.commentInfo = new CommentInfo(r);
        if (!this.commentInfo.isComment()) {
            throw new CommentException("resource '" + r.getPath() + "' must be a comment");
        }
        this.id = this.assembleCommentId();
        this.cs = (CommentSystem)this.commentInfo.getComponent().adaptTo(CommentSystem.class);
    }

    private Externalizer getExternalizer() {
        if (this.externalizer == null) {
            this.externalizer = (Externalizer)this.resolver.adaptTo(Externalizer.class);
        }
        return this.externalizer;
    }

    public Comment addComment(String message, String author) throws CommentException {
        return this.createComment(message, author, null);
    }

    @Override
    public CommentSystem getCommentSystem() {
        return this.cs;
    }

    @Override
    public Resource getComponent() {
        return this.commentInfo.getComponent();
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        try {
            return (T)((ValueMap)this.commentInfo.getResource().adaptTo(ValueMap.class)).get(name, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        try {
            return (T)((ValueMap)this.commentInfo.getResource().adaptTo(ValueMap.class)).get(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public Resource getResource() {
        return this.commentInfo.getResource();
    }

    @Override
    public String getPath() {
        return this.commentInfo.getResource().getPath();
    }

    @Override
    public String getUrl() {
        return this.cs.getPath() + ".html" + "#" + this.getId();
    }

    @Override
    public String getFullUrl(SlingHttpServletRequest request) {
        if (request != null) {
            return this.getExternalizer().absoluteLink(request, request.getScheme(), this.getUrl());
        }
        return this.getExternalizer().absoluteLink(this.commentInfo.getResource().getResourceResolver(), "http", this.getUrl());
    }

    @Override
    public String getRefreshUrl() {
        return this.cs.getPath() + ".html" + "?cq_ck=" + System.currentTimeMillis() + "#" + this.getId();
    }

    @Override
    public CollabUser getAuthor() {
        return new CollabUserImpl(this.commentInfo.getResource());
    }

    @Override
    public String getMessage() {
        return this.getProperty("jcr:description", "");
    }

    @Override
    public Date getDate() {
        return this.getProperty("added", this.getProperty("jcr:created", new Date(this.commentInfo.getResource().getResourceMetadata().getCreationTime())));
    }

    @Override
    public void setDate(Date date) throws CommentException {
        try {
            Node node = (Node)this.commentInfo.getResource().adaptTo(Node.class);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            node.setProperty("added", cal);
        }
        catch (RepositoryException re) {
            throw new CommentException("failed to set date", re);
        }
    }

    @Override
    public boolean isPending() {
        return CommentUtil.isPending(this.commentInfo.getResource(), this.commentInfo.getComponent());
    }

    @Override
    public boolean isApproved() {
        return CommentUtil.isApproved(this.commentInfo.getResource(), this.commentInfo.getComponent());
    }

    @Override
    public boolean isDenied() {
        return "false".equals(CommentUtil.getProperty(this.commentInfo.getResource(), "approved", ""));
    }

    @Override
    public boolean isSpam() {
        return CommentUtil.isSpam(this.commentInfo.getResource());
    }

    public boolean equals(Object o) {
        return o instanceof Comment && ((Comment)o).getPath().equals(this.getPath());
    }

    @Override
    public String addAttachment(String name, Binary data, String contentType) throws CommentException {
        try {
            return this.addAttachmentNode(name, data, contentType, this.getPath()).getPath();
        }
        catch (RepositoryException e) {
            throw new CommentException("Failed to add attachment " + name, e);
        }
    }

    @Override
    public void deleteAttachment(String attPath) throws CommentException {
        this.deleteAttachmentNode(attPath);
    }

    @Override
    public void addAttachments(List<DataSource> attachments) {
        if (attachments != null) {
            for (DataSource fileAttachment : attachments) {
                try {
                    if (fileAttachment == null || fileAttachment.getInputStream().available() <= 0) continue;
                    this.addAttachment(fileAttachment.getName(), ((Session)this.resolver.adaptTo(Session.class)).getValueFactory().createBinary(fileAttachment.getInputStream()), fileAttachment.getContentType());
                }
                catch (CommentException e) {
                    log.error("Failed to create/edit comment due to failed attachment upload of file" + fileAttachment.getName(), (Throwable)((Object)e));
                }
                catch (IOException e) {
                    log.error("Failed to create/edit comment due to failed attachment upload of file" + fileAttachment.getName(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.error("Failed to create/edit comment due to failed attachment upload of file" + fileAttachment.getName(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isTopLevel() {
        for (Resource parent = this.getResource().getParent(); parent != null; parent = parent.getParent()) {
            try {
                Property primaryType = ((Node)parent.adaptTo(Node.class)).getProperty("jcr:primaryType");
                String sprimaryType = primaryType.getString();
                if (sprimaryType.equals("cq:CommentContent")) {
                    return true;
                }
                if (!primaryType.getString().equals("cq:Comment")) continue;
                return false;
            }
            catch (RepositoryException e) {
                log.error("Error computing isTopLevel for " + this.getPath(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public Resource addAttachment(String name, InputStream inputStream, String mimeType) throws CommentException {
        try {
            Node attachment = this.addAttachmentNode(name, ((Session)this.resolver.adaptTo(Session.class)).getValueFactory().createBinary(inputStream), mimeType, this.commentInfo.getResource().getPath());
            this.save();
            return this.resolver.getResource(attachment.getPath());
        }
        catch (RepositoryException e) {
            Resource r = this.commentInfo.getResource();
            String path = r != null ? r.getPath() : "";
            throw new CommentException("Failed to create attachment " + name + " for comment " + path, e);
        }
    }

    public Resource getAttachment(String name) {
        Resource attachments = this.getAttachmentsNode(this.commentInfo.getResource());
        if (attachments != null) {
            Resource child = attachments.getChild(name);
            return ResourceUtil.isA((Resource)child, (String)"nt:file") ? child : null;
        }
        return null;
    }

    public Map<String, Resource> getAttachmentMap() {
        HashMap<String, Resource> attachments = new HashMap<String, Resource>();
        Resource resource = this.getAttachmentsNode(this.commentInfo.getResource());
        Iterator iterator = resource.listChildren();
        while (iterator.hasNext()) {
            Resource child = (Resource)iterator.next();
            if (!ResourceUtil.isA((Resource)child, (String)"nt:file")) continue;
            attachments.put(child.getName(), child);
        }
        return attachments;
    }

    public String getCreatedBy() {
        return this.getAuthor().getName();
    }

    public Calendar getCreated() {
        return (Calendar)((Object)this.getProperty("added", (Object)Calendar.class));
    }

    public ValueMap getProperties() {
        try {
            return (ValueMap)this.getResource().adaptTo(ValueMap.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public CommentCollection getCollection() {
        return this.cs;
    }

    public void removeAttachment(String name) throws CommentException {
        Resource attachment = this.getAttachment(name);
        try {
            if (attachment != null) {
                Node node = (Node)attachment.adaptTo(Node.class);
                node.remove();
                this.save();
            }
        }
        catch (RepositoryException e) {
            Resource r = this.commentInfo.getResource();
            String path = r != null ? r.getPath() : "";
            throw new CommentException("Failed to remove attachment " + name + " for comment " + path, e);
        }
    }

    public void remove() {
        Resource resource = this.commentInfo.getResource();
        try {
            Node node = (Node)resource.adaptTo(Node.class);
            node.remove();
            this.save();
        }
        catch (RepositoryException e) {
            String path = resource != null ? resource.getPath() : "";
            throw new CommentException("Failed to remove comment " + path, e);
        }
    }

    protected Resource getAttachmentsNode(Resource resource) {
        return resource.getChild("attachments");
    }
}

